--
-- PostgreSQL database dump
--

-- Dumped from database version 14.2
-- Dumped by pg_dump version 14.2

-- Started on 2022-08-25 15:05:30

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- TOC entry 23 (class 2615 OID 2455411)
-- Name: a_aeropuerto_superficie; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA a_aeropuerto_superficie;


ALTER SCHEMA a_aeropuerto_superficie OWNER TO postgres;

--
-- TOC entry 28 (class 2615 OID 2455412)
-- Name: catalogo_objetos; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA catalogo_objetos;


ALTER SCHEMA catalogo_objetos OWNER TO postgres;

--
-- TOC entry 12 (class 2615 OID 2455413)
-- Name: d_linderos_propiedad; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA d_linderos_propiedad;


ALTER SCHEMA d_linderos_propiedad OWNER TO postgres;

--
-- TOC entry 11 (class 2615 OID 2455414)
-- Name: gs_asociado_poblados; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA gs_asociado_poblados;


ALTER SCHEMA gs_asociado_poblados OWNER TO postgres;

--
-- TOC entry 20 (class 2615 OID 2455415)
-- Name: gs_construcciones; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA gs_construcciones;


ALTER SCHEMA gs_construcciones OWNER TO postgres;

--
-- TOC entry 24 (class 2615 OID 2455416)
-- Name: gs_recreacion; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA gs_recreacion;


ALTER SCHEMA gs_recreacion OWNER TO postgres;

--
-- TOC entry 18 (class 2615 OID 2455417)
-- Name: ho_aguas_interiores; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA ho_aguas_interiores;


ALTER SCHEMA ho_aguas_interiores OWNER TO postgres;

--
-- TOC entry 32 (class 2615 OID 2455418)
-- Name: ho_puertos_muelles; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA ho_puertos_muelles;


ALTER SCHEMA ho_puertos_muelles OWNER TO postgres;

--
-- TOC entry 19 (class 2615 OID 2455419)
-- Name: ho_regulacion_zonas_restringidas; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA ho_regulacion_zonas_restringidas;


ALTER SCHEMA ho_regulacion_zonas_restringidas OWNER TO postgres;

--
-- TOC entry 15 (class 2615 OID 2455420)
-- Name: ho_zonas_costeras; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA ho_zonas_costeras;


ALTER SCHEMA ho_zonas_costeras OWNER TO postgres;

--
-- TOC entry 16 (class 2615 OID 2455421)
-- Name: ii_agropecuaria; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA ii_agropecuaria;


ALTER SCHEMA ii_agropecuaria OWNER TO postgres;

--
-- TOC entry 30 (class 2615 OID 2455422)
-- Name: it_asociado_transportacion; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA it_asociado_transportacion;


ALTER SCHEMA it_asociado_transportacion OWNER TO postgres;

--
-- TOC entry 25 (class 2615 OID 2455423)
-- Name: it_cruces_enlaces; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA it_cruces_enlaces;


ALTER SCHEMA it_cruces_enlaces OWNER TO postgres;

--
-- TOC entry 29 (class 2615 OID 2455424)
-- Name: it_ferrocarriles; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA it_ferrocarriles;


ALTER SCHEMA it_ferrocarriles OWNER TO postgres;

--
-- TOC entry 14 (class 2615 OID 2455425)
-- Name: it_transporte_terrestre; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA it_transporte_terrestre;


ALTER SCHEMA it_transporte_terrestre OWNER TO postgres;

--
-- TOC entry 31 (class 2615 OID 2455426)
-- Name: proyecto_qgis3; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA proyecto_qgis3;


ALTER SCHEMA proyecto_qgis3 OWNER TO postgres;

--
-- TOC entry 27 (class 2615 OID 2455427)
-- Name: visualizacion; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA visualizacion;


ALTER SCHEMA visualizacion OWNER TO postgres;

--
-- TOC entry 6 (class 3079 OID 17619)
-- Name: address_standardizer; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS address_standardizer WITH SCHEMA public;


--
-- TOC entry 7444 (class 0 OID 0)
-- Dependencies: 6
-- Name: EXTENSION address_standardizer; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION address_standardizer IS 'Used to parse an address into constituent elements. Generally used to support geocoding address normalization step.';


--
-- TOC entry 5 (class 3079 OID 17608)
-- Name: fuzzystrmatch; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS fuzzystrmatch WITH SCHEMA public;


--
-- TOC entry 7445 (class 0 OID 0)
-- Dependencies: 5
-- Name: EXTENSION fuzzystrmatch; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION fuzzystrmatch IS 'determine similarities and distance between strings';


--
-- TOC entry 2 (class 3079 OID 16386)
-- Name: postgis; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS postgis WITH SCHEMA public;


--
-- TOC entry 7446 (class 0 OID 0)
-- Dependencies: 2
-- Name: EXTENSION postgis; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION postgis IS 'PostGIS geometry and geography spatial types and functions';


--
-- TOC entry 8 (class 3079 OID 18036)
-- Name: postgis_raster; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS postgis_raster WITH SCHEMA public;


--
-- TOC entry 7447 (class 0 OID 0)
-- Dependencies: 8
-- Name: EXTENSION postgis_raster; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION postgis_raster IS 'PostGIS raster types and functions';


--
-- TOC entry 4 (class 3079 OID 17581)
-- Name: postgis_sfcgal; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS postgis_sfcgal WITH SCHEMA public;


--
-- TOC entry 7448 (class 0 OID 0)
-- Dependencies: 4
-- Name: EXTENSION postgis_sfcgal; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION postgis_sfcgal IS 'PostGIS SFCGAL functions';

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- TOC entry 309 (class 1259 OID 2455428)
-- Name: aeropuerto_a; Type: TABLE; Schema: a_aeropuerto_superficie; Owner: postgres
--

CREATE TABLE a_aeropuerto_superficie.aeropuerto_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'GB005'::character varying NOT NULL,
    nam character varying(80),
    acc integer NOT NULL,
    iko character varying(4),
    fuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'GB005'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE a_aeropuerto_superficie.aeropuerto_a OWNER TO postgres;

--
-- TOC entry 7451 (class 0 OID 0)
-- Dependencies: 309
-- Name: TABLE aeropuerto_a; Type: COMMENT; Schema: a_aeropuerto_superficie; Owner: postgres
--

COMMENT ON TABLE a_aeropuerto_superficie.aeropuerto_a IS 'Zona provista de un conjunto de pistas, instalaciones y servicios destinados al tráfico regular de aeronaves.';


--
-- TOC entry 310 (class 1259 OID 2455439)
-- Name: aeropuerto_a_gid_seq; Type: SEQUENCE; Schema: a_aeropuerto_superficie; Owner: postgres
--

CREATE SEQUENCE a_aeropuerto_superficie.aeropuerto_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE a_aeropuerto_superficie.aeropuerto_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7452 (class 0 OID 0)
-- Dependencies: 310
-- Name: aeropuerto_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: a_aeropuerto_superficie; Owner: postgres
--

ALTER SEQUENCE a_aeropuerto_superficie.aeropuerto_a_gid_seq OWNED BY a_aeropuerto_superficie.aeropuerto_a.gid;


--
-- TOC entry 311 (class 1259 OID 2455440)
-- Name: acc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.acc (
    acc integer NOT NULL,
    acc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.acc OWNER TO postgres;

--
-- TOC entry 312 (class 1259 OID 2455443)
-- Name: atc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.atc (
    atc integer NOT NULL,
    atc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.atc OWNER TO postgres;

--
-- TOC entry 313 (class 1259 OID 2455446)
-- Name: bsc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.bsc (
    bsc integer NOT NULL,
    bsc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.bsc OWNER TO postgres;

--
-- TOC entry 314 (class 1259 OID 2455449)
-- Name: catalogo_objetos; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.catalogo_objetos (
    fcode character varying(5) NOT NULL,
    objeto character varying(80),
    descripcion character varying(350),
    gid integer NOT NULL
);


ALTER TABLE catalogo_objetos.catalogo_objetos OWNER TO postgres;

--
-- TOC entry 315 (class 1259 OID 2455452)
-- Name: catalogo_objetos_gid_seq; Type: SEQUENCE; Schema: catalogo_objetos; Owner: postgres
--

CREATE SEQUENCE catalogo_objetos.catalogo_objetos_gid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE catalogo_objetos.catalogo_objetos_gid_seq OWNER TO postgres;

--
-- TOC entry 7453 (class 0 OID 0)
-- Dependencies: 315
-- Name: catalogo_objetos_gid_seq; Type: SEQUENCE OWNED BY; Schema: catalogo_objetos; Owner: postgres
--

ALTER SEQUENCE catalogo_objetos.catalogo_objetos_gid_seq OWNED BY catalogo_objetos.catalogo_objetos.gid;


--
-- TOC entry 316 (class 1259 OID 2455453)
-- Name: dit; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.dit (
    dit integer NOT NULL,
    dit_desc character varying(80)
);


ALTER TABLE catalogo_objetos.dit OWNER TO postgres;

--
-- TOC entry 317 (class 1259 OID 2455456)
-- Name: ela; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.ela (
    ela integer NOT NULL,
    ela_desc character varying(80)
);


ALTER TABLE catalogo_objetos.ela OWNER TO postgres;

--
-- TOC entry 318 (class 1259 OID 2455459)
-- Name: fco; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.fco (
    fco integer NOT NULL,
    fco_desc character varying(80)
);


ALTER TABLE catalogo_objetos.fco OWNER TO postgres;

--
-- TOC entry 319 (class 1259 OID 2455462)
-- Name: fti; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.fti (
    fti integer NOT NULL,
    fti_desc character varying(80)
);


ALTER TABLE catalogo_objetos.fti OWNER TO postgres;

--
-- TOC entry 320 (class 1259 OID 2455465)
-- Name: fuc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.fuc (
    fuc integer NOT NULL,
    fuc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.fuc OWNER TO postgres;

--
-- TOC entry 321 (class 1259 OID 2455468)
-- Name: hct; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.hct (
    hct integer NOT NULL,
    hct_desc character varying(80)
);


ALTER TABLE catalogo_objetos.hct OWNER TO postgres;

--
-- TOC entry 322 (class 1259 OID 2455471)
-- Name: hyp; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.hyp (
    hyp integer NOT NULL,
    hyp_desc character varying(80)
);


ALTER TABLE catalogo_objetos.hyp OWNER TO postgres;

--
-- TOC entry 323 (class 1259 OID 2455474)
-- Name: kos; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.kos (
    kos integer NOT NULL,
    kos_desc character varying(80)
);


ALTER TABLE catalogo_objetos.kos OWNER TO postgres;

--
-- TOC entry 324 (class 1259 OID 2455477)
-- Name: loc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.loc (
    loc integer NOT NULL,
    loc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.loc OWNER TO postgres;

--
-- TOC entry 325 (class 1259 OID 2455480)
-- Name: mes; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.mes (
    mes integer NOT NULL,
    mes_desc character varying(80)
);


ALTER TABLE catalogo_objetos.mes OWNER TO postgres;

--
-- TOC entry 326 (class 1259 OID 2455483)
-- Name: rdt; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.rdt (
    rdt integer NOT NULL,
    rdt_desc character varying(80)
);


ALTER TABLE catalogo_objetos.rdt OWNER TO postgres;

--
-- TOC entry 327 (class 1259 OID 2455486)
-- Name: rel; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.rel (
    rel integer NOT NULL,
    rel_desc character varying(80)
);


ALTER TABLE catalogo_objetos.rel OWNER TO postgres;

--
-- TOC entry 328 (class 1259 OID 2455489)
-- Name: rgc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.rgc (
    rgc integer NOT NULL,
    rgc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.rgc OWNER TO postgres;

--
-- TOC entry 329 (class 1259 OID 2455492)
-- Name: rra; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.rra (
    rra integer NOT NULL,
    rra_desc character varying(80)
);


ALTER TABLE catalogo_objetos.rra OWNER TO postgres;

--
-- TOC entry 330 (class 1259 OID 2455495)
-- Name: rrc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.rrc (
    rrc integer NOT NULL,
    rrc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.rrc OWNER TO postgres;

--
-- TOC entry 331 (class 1259 OID 2455498)
-- Name: rst; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.rst (
    rst integer NOT NULL,
    rst_desc character varying(80)
);


ALTER TABLE catalogo_objetos.rst OWNER TO postgres;

--
-- TOC entry 332 (class 1259 OID 2455501)
-- Name: slt; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.slt (
    slt integer NOT NULL,
    slt_desc character varying(80)
);


ALTER TABLE catalogo_objetos.slt OWNER TO postgres;

--
-- TOC entry 333 (class 1259 OID 2455504)
-- Name: smc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.smc (
    smc integer NOT NULL,
    smc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.smc OWNER TO postgres;

--
-- TOC entry 334 (class 1259 OID 2455507)
-- Name: tra; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.tra (
    tra integer NOT NULL,
    tra_desc character varying(80)
);


ALTER TABLE catalogo_objetos.tra OWNER TO postgres;

--
-- TOC entry 335 (class 1259 OID 2455510)
-- Name: tuc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.tuc (
    tuc integer NOT NULL,
    tuc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.tuc OWNER TO postgres;

--
-- TOC entry 336 (class 1259 OID 2455513)
-- Name: typ; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.typ (
    typ integer NOT NULL,
    typ_desc character varying(80)
);


ALTER TABLE catalogo_objetos.typ OWNER TO postgres;

--
-- TOC entry 337 (class 1259 OID 2455516)
-- Name: uuc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.uuc (
    uuc integer NOT NULL,
    uuc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.uuc OWNER TO postgres;

--
-- TOC entry 338 (class 1259 OID 2455519)
-- Name: wtc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.wtc (
    wtc integer NOT NULL,
    wtc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.wtc OWNER TO postgres;

--
-- TOC entry 339 (class 1259 OID 2455522)
-- Name: wti; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.wti (
    wti integer NOT NULL,
    wti_desc character varying(80)
);


ALTER TABLE catalogo_objetos.wti OWNER TO postgres;

--
-- TOC entry 340 (class 1259 OID 2455525)
-- Name: punto_control_p; Type: TABLE; Schema: d_linderos_propiedad; Owner: postgres
--

CREATE TABLE d_linderos_propiedad.punto_control_p (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'ZB050'::character varying NOT NULL,
    acc integer NOT NULL,
    ela integer NOT NULL,
    zvh double precision,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'POINT'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'ZB050'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE d_linderos_propiedad.punto_control_p OWNER TO postgres;

--
-- TOC entry 7454 (class 0 OID 0)
-- Dependencies: 340
-- Name: TABLE punto_control_p; Type: COMMENT; Schema: d_linderos_propiedad; Owner: postgres
--

COMMENT ON TABLE d_linderos_propiedad.punto_control_p IS 'Objeto en el terreno de ubicación conocida, donde se ha determinado las coordenadas horizontal y/o vertical por métodos geodésicos o topográficos.';


--
-- TOC entry 341 (class 1259 OID 2455536)
-- Name: vertice_geodesico_p_gid_seq; Type: SEQUENCE; Schema: d_linderos_propiedad; Owner: postgres
--

CREATE SEQUENCE d_linderos_propiedad.vertice_geodesico_p_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE d_linderos_propiedad.vertice_geodesico_p_gid_seq OWNER TO postgres;

--
-- TOC entry 7455 (class 0 OID 0)
-- Dependencies: 341
-- Name: vertice_geodesico_p_gid_seq; Type: SEQUENCE OWNED BY; Schema: d_linderos_propiedad; Owner: postgres
--

ALTER SEQUENCE d_linderos_propiedad.vertice_geodesico_p_gid_seq OWNED BY d_linderos_propiedad.punto_control_p.gid;


--
-- TOC entry 342 (class 1259 OID 2455537)
-- Name: cementerio_a; Type: TABLE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE TABLE gs_asociado_poblados.cementerio_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AL030'::character varying NOT NULL,
    nam character varying(80),
    rel integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AL030'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_asociado_poblados.cementerio_a OWNER TO postgres;

--
-- TOC entry 7456 (class 0 OID 0)
-- Dependencies: 342
-- Name: TABLE cementerio_a; Type: COMMENT; Schema: gs_asociado_poblados; Owner: postgres
--

COMMENT ON TABLE gs_asociado_poblados.cementerio_a IS 'Sitio de estructuras asociadas, utilizadas para el entierro de muertos.';


--
-- TOC entry 343 (class 1259 OID 2455548)
-- Name: cementerio_a_gid_seq; Type: SEQUENCE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE SEQUENCE gs_asociado_poblados.cementerio_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_asociado_poblados.cementerio_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7457 (class 0 OID 0)
-- Dependencies: 343
-- Name: cementerio_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER SEQUENCE gs_asociado_poblados.cementerio_a_gid_seq OWNED BY gs_asociado_poblados.cementerio_a.gid;


--
-- TOC entry 344 (class 1259 OID 2455549)
-- Name: cerca_l; Type: TABLE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE TABLE gs_asociado_poblados.cerca_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AL070'::character varying NOT NULL,
    fti integer NOT NULL,
    wti integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AL070'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_asociado_poblados.cerca_l OWNER TO postgres;

--
-- TOC entry 7458 (class 0 OID 0)
-- Dependencies: 344
-- Name: TABLE cerca_l; Type: COMMENT; Schema: gs_asociado_poblados; Owner: postgres
--

COMMENT ON TABLE gs_asociado_poblados.cerca_l IS 'Barrera artificial construida por el hombre, de estructura relativamente liviana y que es utilizada como cercado o límite.';


--
-- TOC entry 345 (class 1259 OID 2455560)
-- Name: cerca_l_gid_seq; Type: SEQUENCE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE SEQUENCE gs_asociado_poblados.cerca_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_asociado_poblados.cerca_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7459 (class 0 OID 0)
-- Dependencies: 345
-- Name: cerca_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER SEQUENCE gs_asociado_poblados.cerca_l_gid_seq OWNED BY gs_asociado_poblados.cerca_l.gid;


--
-- TOC entry 346 (class 1259 OID 2455561)
-- Name: escalinata_a; Type: TABLE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE TABLE gs_asociado_poblados.escalinata_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ150'::character varying NOT NULL,
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ150'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_asociado_poblados.escalinata_a OWNER TO postgres;

--
-- TOC entry 7460 (class 0 OID 0)
-- Dependencies: 346
-- Name: TABLE escalinata_a; Type: COMMENT; Schema: gs_asociado_poblados; Owner: postgres
--

COMMENT ON TABLE gs_asociado_poblados.escalinata_a IS 'Serie de escalones que sirven para subir a un plano más elevado o para bajar a un plano inferior. Para fines catastrales se levantarán únicamente las escalinatas públicas que permitan identificar el lindero de un predio.';


--
-- TOC entry 347 (class 1259 OID 2455572)
-- Name: escalinata_a_gid_seq; Type: SEQUENCE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE SEQUENCE gs_asociado_poblados.escalinata_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_asociado_poblados.escalinata_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7461 (class 0 OID 0)
-- Dependencies: 347
-- Name: escalinata_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER SEQUENCE gs_asociado_poblados.escalinata_a_gid_seq OWNED BY gs_asociado_poblados.escalinata_a.gid;


--
-- TOC entry 348 (class 1259 OID 2455573)
-- Name: muro_l; Type: TABLE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE TABLE gs_asociado_poblados.muro_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AL260'::character varying NOT NULL,
    wti integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AL260'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_asociado_poblados.muro_l OWNER TO postgres;

--
-- TOC entry 7462 (class 0 OID 0)
-- Dependencies: 348
-- Name: TABLE muro_l; Type: COMMENT; Schema: gs_asociado_poblados; Owner: postgres
--

COMMENT ON TABLE gs_asociado_poblados.muro_l IS 'Barrera hecha por el hombre de material resistente y que es utilizado como límite o para protección. Es aquel objeto que permite identificar el lindero de un predio.';


--
-- TOC entry 349 (class 1259 OID 2455584)
-- Name: muro_l_gid_seq; Type: SEQUENCE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE SEQUENCE gs_asociado_poblados.muro_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_asociado_poblados.muro_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7463 (class 0 OID 0)
-- Dependencies: 349
-- Name: muro_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER SEQUENCE gs_asociado_poblados.muro_l_gid_seq OWNED BY gs_asociado_poblados.muro_l.gid;


--
-- TOC entry 350 (class 1259 OID 2455585)
-- Name: plaza_publica_a; Type: TABLE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE TABLE gs_asociado_poblados.plaza_publica_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AL170'::character varying NOT NULL,
    nam character varying(80),
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AL170'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_asociado_poblados.plaza_publica_a OWNER TO postgres;

--
-- TOC entry 7464 (class 0 OID 0)
-- Dependencies: 350
-- Name: TABLE plaza_publica_a; Type: COMMENT; Schema: gs_asociado_poblados; Owner: postgres
--

COMMENT ON TABLE gs_asociado_poblados.plaza_publica_a IS 'Sitio abierto que sirve como lugar de reunión pública, en una zona poblada para diversos usos.';


--
-- TOC entry 351 (class 1259 OID 2455596)
-- Name: plaza_publica_a_gid_seq; Type: SEQUENCE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE SEQUENCE gs_asociado_poblados.plaza_publica_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_asociado_poblados.plaza_publica_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7465 (class 0 OID 0)
-- Dependencies: 351
-- Name: plaza_publica_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER SEQUENCE gs_asociado_poblados.plaza_publica_a_gid_seq OWNED BY gs_asociado_poblados.plaza_publica_a.gid;


--
-- TOC entry 352 (class 1259 OID 2455597)
-- Name: edificio_a; Type: TABLE; Schema: gs_construcciones; Owner: postgres
--

CREATE TABLE gs_construcciones.edificio_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AL015'::character varying NOT NULL,
    nam character varying(200),
    acc integer NOT NULL,
    uuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AL015'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_construcciones.edificio_a OWNER TO postgres;

--
-- TOC entry 7466 (class 0 OID 0)
-- Dependencies: 352
-- Name: TABLE edificio_a; Type: COMMENT; Schema: gs_construcciones; Owner: postgres
--

COMMENT ON TABLE gs_construcciones.edificio_a IS 'Construcción independiente, techada, generalmente con paredes; destinada al hábitat y/o actividades de personas. Para fines catastrales se incluye choza, misma que deberá ser catalogada en el atributo txt como "Choza".';


--
-- TOC entry 353 (class 1259 OID 2455608)
-- Name: edificio_a_gid_seq; Type: SEQUENCE; Schema: gs_construcciones; Owner: postgres
--

CREATE SEQUENCE gs_construcciones.edificio_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_construcciones.edificio_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7467 (class 0 OID 0)
-- Dependencies: 353
-- Name: edificio_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_construcciones; Owner: postgres
--

ALTER SEQUENCE gs_construcciones.edificio_a_gid_seq OWNED BY gs_construcciones.edificio_a.gid;


--
-- TOC entry 354 (class 1259 OID 2455609)
-- Name: cancha_a; Type: TABLE; Schema: gs_recreacion; Owner: postgres
--

CREATE TABLE gs_recreacion.cancha_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AK040'::character varying NOT NULL,
    nam character varying(80),
    smc integer NOT NULL,
    kos integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AK040'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_recreacion.cancha_a OWNER TO postgres;

--
-- TOC entry 7468 (class 0 OID 0)
-- Dependencies: 354
-- Name: TABLE cancha_a; Type: COMMENT; Schema: gs_recreacion; Owner: postgres
--

COMMENT ON TABLE gs_recreacion.cancha_a IS 'Lugar al aire libre destinado a eventos deportivos, ejercicio o juegos.';


--
-- TOC entry 355 (class 1259 OID 2455620)
-- Name: cancha_a_gid_seq; Type: SEQUENCE; Schema: gs_recreacion; Owner: postgres
--

CREATE SEQUENCE gs_recreacion.cancha_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_recreacion.cancha_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7469 (class 0 OID 0)
-- Dependencies: 355
-- Name: cancha_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_recreacion; Owner: postgres
--

ALTER SEQUENCE gs_recreacion.cancha_a_gid_seq OWNED BY gs_recreacion.cancha_a.gid;


--
-- TOC entry 356 (class 1259 OID 2455621)
-- Name: estadio_a; Type: TABLE; Schema: gs_recreacion; Owner: postgres
--

CREATE TABLE gs_recreacion.estadio_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AK165'::character varying NOT NULL,
    nam character varying(80),
    acc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AK165'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_recreacion.estadio_a OWNER TO postgres;

--
-- TOC entry 7470 (class 0 OID 0)
-- Dependencies: 356
-- Name: TABLE estadio_a; Type: COMMENT; Schema: gs_recreacion; Owner: postgres
--

COMMENT ON TABLE gs_recreacion.estadio_a IS 'Campo deportivo parcial o totalmente rodeado por una estructura diseñada para permitir a los espectadores ver un evento de pie o sentados; a menudo diseñados en forma y tamaño para dar cabida a deportes específicos (por ejemplo: el fútbol).';


--
-- TOC entry 357 (class 1259 OID 2455632)
-- Name: estadio_a_gid_seq; Type: SEQUENCE; Schema: gs_recreacion; Owner: postgres
--

CREATE SEQUENCE gs_recreacion.estadio_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_recreacion.estadio_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7471 (class 0 OID 0)
-- Dependencies: 357
-- Name: estadio_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_recreacion; Owner: postgres
--

ALTER SEQUENCE gs_recreacion.estadio_a_gid_seq OWNED BY gs_recreacion.estadio_a.gid;


--
-- TOC entry 358 (class 1259 OID 2455633)
-- Name: parque_a; Type: TABLE; Schema: gs_recreacion; Owner: postgres
--

CREATE TABLE gs_recreacion.parque_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AK120'::character varying NOT NULL,
    nam character varying(80),
    fuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AK120'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_recreacion.parque_a OWNER TO postgres;

--
-- TOC entry 7472 (class 0 OID 0)
-- Dependencies: 358
-- Name: TABLE parque_a; Type: COMMENT; Schema: gs_recreacion; Owner: postgres
--

COMMENT ON TABLE gs_recreacion.parque_a IS 'Área utilizada con propósitos recreacionales u ornamentales.';


--
-- TOC entry 359 (class 1259 OID 2455644)
-- Name: parque_a_gid_seq; Type: SEQUENCE; Schema: gs_recreacion; Owner: postgres
--

CREATE SEQUENCE gs_recreacion.parque_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_recreacion.parque_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7473 (class 0 OID 0)
-- Dependencies: 359
-- Name: parque_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_recreacion; Owner: postgres
--

ALTER SEQUENCE gs_recreacion.parque_a_gid_seq OWNED BY gs_recreacion.parque_a.gid;


--
-- TOC entry 360 (class 1259 OID 2455645)
-- Name: piscina_a; Type: TABLE; Schema: gs_recreacion; Owner: postgres
--

CREATE TABLE gs_recreacion.piscina_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AK170'::character varying NOT NULL,
    nam character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AK170'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_recreacion.piscina_a OWNER TO postgres;

--
-- TOC entry 7474 (class 0 OID 0)
-- Dependencies: 360
-- Name: TABLE piscina_a; Type: COMMENT; Schema: gs_recreacion; Owner: postgres
--

COMMENT ON TABLE gs_recreacion.piscina_a IS 'Construcción destinada a contener agua con fines de recreación y natación.';


--
-- TOC entry 361 (class 1259 OID 2455656)
-- Name: piscina_a_gid_seq; Type: SEQUENCE; Schema: gs_recreacion; Owner: postgres
--

CREATE SEQUENCE gs_recreacion.piscina_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_recreacion.piscina_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7475 (class 0 OID 0)
-- Dependencies: 361
-- Name: piscina_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_recreacion; Owner: postgres
--

ALTER SEQUENCE gs_recreacion.piscina_a_gid_seq OWNED BY gs_recreacion.piscina_a.gid;


--
-- TOC entry 362 (class 1259 OID 2455657)
-- Name: plaza_toros_a; Type: TABLE; Schema: gs_recreacion; Owner: postgres
--

CREATE TABLE gs_recreacion.plaza_toros_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AK166'::character varying NOT NULL,
    nam character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AK166'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_recreacion.plaza_toros_a OWNER TO postgres;

--
-- TOC entry 7476 (class 0 OID 0)
-- Dependencies: 362
-- Name: TABLE plaza_toros_a; Type: COMMENT; Schema: gs_recreacion; Owner: postgres
--

COMMENT ON TABLE gs_recreacion.plaza_toros_a IS 'Construcción generalmente circular u ovalada, de cielo abierto, rodeada por graderíos para los espectadores.';


--
-- TOC entry 363 (class 1259 OID 2455668)
-- Name: plaza_toros_a_gid_seq; Type: SEQUENCE; Schema: gs_recreacion; Owner: postgres
--

CREATE SEQUENCE gs_recreacion.plaza_toros_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_recreacion.plaza_toros_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7477 (class 0 OID 0)
-- Dependencies: 363
-- Name: plaza_toros_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_recreacion; Owner: postgres
--

ALTER SEQUENCE gs_recreacion.plaza_toros_a_gid_seq OWNED BY gs_recreacion.plaza_toros_a.gid;


--
-- TOC entry 364 (class 1259 OID 2455669)
-- Name: acequia_l; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.acequia_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH030'::character varying NOT NULL,
    hyp integer NOT NULL,
    dit integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH030'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.acequia_l OWNER TO postgres;

--
-- TOC entry 7478 (class 0 OID 0)
-- Dependencies: 364
-- Name: TABLE acequia_l; Type: COMMENT; Schema: ho_aguas_interiores; Owner: postgres
--

COMMENT ON TABLE ho_aguas_interiores.acequia_l IS 'Excavación poco profunda construida en tierra con propósitos de drenaje o irrigación. Se debe levantar los dos lados de la acequia, no únicamente el eje. ';


--
-- TOC entry 365 (class 1259 OID 2455680)
-- Name: acequia_l_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.acequia_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.acequia_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7479 (class 0 OID 0)
-- Dependencies: 365
-- Name: acequia_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.acequia_l_gid_seq OWNED BY ho_aguas_interiores.acequia_l.gid;


--
-- TOC entry 366 (class 1259 OID 2455681)
-- Name: acueducto_canal_a; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.acueducto_canal_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH010'::character varying NOT NULL,
    atc integer NOT NULL,
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH010'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.acueducto_canal_a OWNER TO postgres;

--
-- TOC entry 7480 (class 0 OID 0)
-- Dependencies: 366
-- Name: TABLE acueducto_canal_a; Type: COMMENT; Schema: ho_aguas_interiores; Owner: postgres
--

COMMENT ON TABLE ho_aguas_interiores.acueducto_canal_a IS 'Cauce artificial que transporta agua en forma de flujo continuo desde un lugar en el que ésta es accesible para consumo u otros usos. ';


--
-- TOC entry 367 (class 1259 OID 2455692)
-- Name: acueducto_canal_a_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.acueducto_canal_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.acueducto_canal_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7481 (class 0 OID 0)
-- Dependencies: 367
-- Name: acueducto_canal_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.acueducto_canal_a_gid_seq OWNED BY ho_aguas_interiores.acueducto_canal_a.gid;


--
-- TOC entry 368 (class 1259 OID 2455693)
-- Name: lago_laguna_a; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.lago_laguna_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH080'::character varying NOT NULL,
    nam character varying(80),
    na2 character varying(80),
    hyp integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH080'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.lago_laguna_a OWNER TO postgres;

--
-- TOC entry 7482 (class 0 OID 0)
-- Dependencies: 368
-- Name: TABLE lago_laguna_a; Type: COMMENT; Schema: ho_aguas_interiores; Owner: postgres
--

COMMENT ON TABLE ho_aguas_interiores.lago_laguna_a IS 'Cuerpo de agua, dulce o salada que se encuentra rodeada por tierra.';


--
-- TOC entry 369 (class 1259 OID 2455704)
-- Name: lago_laguna_a_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.lago_laguna_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.lago_laguna_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7483 (class 0 OID 0)
-- Dependencies: 369
-- Name: lago_laguna_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.lago_laguna_a_gid_seq OWNED BY ho_aguas_interiores.lago_laguna_a.gid;


--
-- TOC entry 370 (class 1259 OID 2455705)
-- Name: rio_a; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.rio_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH140'::character varying NOT NULL,
    nam character varying(100),
    na2 character varying(80),
    acc integer NOT NULL,
    hyp integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH140'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.rio_a OWNER TO postgres;

--
-- TOC entry 7484 (class 0 OID 0)
-- Dependencies: 370
-- Name: TABLE rio_a; Type: COMMENT; Schema: ho_aguas_interiores; Owner: postgres
--

COMMENT ON TABLE ho_aguas_interiores.rio_a IS 'Curso de agua que fluye naturalmente.';


--
-- TOC entry 371 (class 1259 OID 2455716)
-- Name: rio_a_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.rio_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.rio_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7485 (class 0 OID 0)
-- Dependencies: 371
-- Name: rio_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.rio_a_gid_seq OWNED BY ho_aguas_interiores.rio_a.gid;


--
-- TOC entry 372 (class 1259 OID 2455717)
-- Name: rio_l; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.rio_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH140'::character varying NOT NULL,
    nam character varying(100),
    na2 character varying(80),
    acc integer NOT NULL,
    hyp integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH140'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.rio_l OWNER TO postgres;

--
-- TOC entry 7486 (class 0 OID 0)
-- Dependencies: 372
-- Name: TABLE rio_l; Type: COMMENT; Schema: ho_aguas_interiores; Owner: postgres
--

COMMENT ON TABLE ho_aguas_interiores.rio_l IS 'Curso de agua que fluye naturalmente.';


--
-- TOC entry 373 (class 1259 OID 2455728)
-- Name: rio_l_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.rio_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.rio_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7487 (class 0 OID 0)
-- Dependencies: 373
-- Name: rio_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.rio_l_gid_seq OWNED BY ho_aguas_interiores.rio_l.gid;


--
-- TOC entry 374 (class 1259 OID 2455729)
-- Name: zanja_l; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.zanja_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH100'::character varying NOT NULL,
    hyp integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH100'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.zanja_l OWNER TO postgres;

--
-- TOC entry 7488 (class 0 OID 0)
-- Dependencies: 374
-- Name: TABLE zanja_l; Type: COMMENT; Schema: ho_aguas_interiores; Owner: postgres
--

COMMENT ON TABLE ho_aguas_interiores.zanja_l IS 'Excavación larga y estrecha que se hace en la tierra para echar los cimientos, conducir las aguas, defender los sembríos o usos semejantes. Se debe levantar los dos lados de la zanja, no únicamente el eje. ';


--
-- TOC entry 375 (class 1259 OID 2455740)
-- Name: zanja_l_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.zanja_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.zanja_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7489 (class 0 OID 0)
-- Dependencies: 375
-- Name: zanja_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.zanja_l_gid_seq OWNED BY ho_aguas_interiores.zanja_l.gid;


--
-- TOC entry 376 (class 1259 OID 2455741)
-- Name: puerto_a; Type: TABLE; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE TABLE ho_puertos_muelles.puerto_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BB005'::character varying NOT NULL,
    nam character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BB005'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_puertos_muelles.puerto_a OWNER TO postgres;

--
-- TOC entry 7490 (class 0 OID 0)
-- Dependencies: 376
-- Name: TABLE puerto_a; Type: COMMENT; Schema: ho_puertos_muelles; Owner: postgres
--

COMMENT ON TABLE ho_puertos_muelles.puerto_a IS 'Conjunto de obras, instalaciones y servicios que proporcionan el espacio necesario para la estancia de los buques mientras realizan operaciones de carga, descarga, almacenaje y tránsito de pasajeros.';


--
-- TOC entry 377 (class 1259 OID 2455752)
-- Name: puerto_a_gid_seq; Type: SEQUENCE; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE SEQUENCE ho_puertos_muelles.puerto_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_puertos_muelles.puerto_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7491 (class 0 OID 0)
-- Dependencies: 377
-- Name: puerto_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER SEQUENCE ho_puertos_muelles.puerto_a_gid_seq OWNED BY ho_puertos_muelles.puerto_a.gid;


--
-- TOC entry 378 (class 1259 OID 2455753)
-- Name: granja_acuatica_a; Type: TABLE; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

CREATE TABLE ho_regulacion_zonas_restringidas.granja_acuatica_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH050'::character varying NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH050'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_regulacion_zonas_restringidas.granja_acuatica_a OWNER TO postgres;

--
-- TOC entry 7492 (class 0 OID 0)
-- Dependencies: 378
-- Name: TABLE granja_acuatica_a; Type: COMMENT; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

COMMENT ON TABLE ho_regulacion_zonas_restringidas.granja_acuatica_a IS 'Área cerrada de agua utilizada para la reproducción o cría de camarones, peces y similares. ';


--
-- TOC entry 379 (class 1259 OID 2455764)
-- Name: granja_acuatica_a_gid_seq; Type: SEQUENCE; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

CREATE SEQUENCE ho_regulacion_zonas_restringidas.granja_acuatica_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_regulacion_zonas_restringidas.granja_acuatica_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7493 (class 0 OID 0)
-- Dependencies: 379
-- Name: granja_acuatica_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

ALTER SEQUENCE ho_regulacion_zonas_restringidas.granja_acuatica_a_gid_seq OWNED BY ho_regulacion_zonas_restringidas.granja_acuatica_a.gid;


--
-- TOC entry 380 (class 1259 OID 2455765)
-- Name: isla_a; Type: TABLE; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE TABLE ho_zonas_costeras.isla_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BA030'::character varying NOT NULL,
    nam character varying(80),
    na2 character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BA030'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_zonas_costeras.isla_a OWNER TO postgres;

--
-- TOC entry 7494 (class 0 OID 0)
-- Dependencies: 380
-- Name: TABLE isla_a; Type: COMMENT; Schema: ho_zonas_costeras; Owner: postgres
--

COMMENT ON TABLE ho_zonas_costeras.isla_a IS 'Masa de tierra más pequeña que un continente y que está rodeada por agua.';


--
-- TOC entry 381 (class 1259 OID 2455776)
-- Name: isla_a_gid_seq; Type: SEQUENCE; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE SEQUENCE ho_zonas_costeras.isla_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_zonas_costeras.isla_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7495 (class 0 OID 0)
-- Dependencies: 381
-- Name: isla_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER SEQUENCE ho_zonas_costeras.isla_a_gid_seq OWNED BY ho_zonas_costeras.isla_a.gid;


--
-- TOC entry 382 (class 1259 OID 2455777)
-- Name: orilla_l; Type: TABLE; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE TABLE ho_zonas_costeras.orilla_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BA010'::character varying NOT NULL,
    acc integer NOT NULL,
    slt integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BA010'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_zonas_costeras.orilla_l OWNER TO postgres;

--
-- TOC entry 7496 (class 0 OID 0)
-- Dependencies: 382
-- Name: TABLE orilla_l; Type: COMMENT; Schema: ho_zonas_costeras; Owner: postgres
--

COMMENT ON TABLE ho_zonas_costeras.orilla_l IS 'Línea donde una superficie está en contacto con un cuerpo de agua. ';


--
-- TOC entry 383 (class 1259 OID 2455788)
-- Name: orilla_l_gid_seq; Type: SEQUENCE; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE SEQUENCE ho_zonas_costeras.orilla_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_zonas_costeras.orilla_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7497 (class 0 OID 0)
-- Dependencies: 383
-- Name: orilla_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER SEQUENCE ho_zonas_costeras.orilla_l_gid_seq OWNED BY ho_zonas_costeras.orilla_l.gid;


--
-- TOC entry 384 (class 1259 OID 2455789)
-- Name: invernadero_a; Type: TABLE; Schema: ii_agropecuaria; Owner: postgres
--

CREATE TABLE ii_agropecuaria.invernadero_a (
    gid integer DEFAULT nextval(('ii_agropecuaria.invernadero_a_gid_seq'::text)::regclass) NOT NULL,
    fcode character varying(5) DEFAULT 'AJ110'::character varying NOT NULL,
    nam character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AJ110'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ii_agropecuaria.invernadero_a OWNER TO postgres;

--
-- TOC entry 7498 (class 0 OID 0)
-- Dependencies: 384
-- Name: TABLE invernadero_a; Type: COMMENT; Schema: ii_agropecuaria; Owner: postgres
--

COMMENT ON TABLE ii_agropecuaria.invernadero_a IS 'Edificio construido principalmente de material transparente en el que la temperatura y la humedad puede ser controlada para el cultivo y/o protección de plantas.';


--
-- TOC entry 385 (class 1259 OID 2455801)
-- Name: invernadero_a_gid_seq; Type: SEQUENCE; Schema: ii_agropecuaria; Owner: postgres
--

CREATE SEQUENCE ii_agropecuaria.invernadero_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ii_agropecuaria.invernadero_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7499 (class 0 OID 0)
-- Dependencies: 385
-- Name: invernadero_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ii_agropecuaria; Owner: postgres
--

ALTER SEQUENCE ii_agropecuaria.invernadero_a_gid_seq OWNED BY ii_agropecuaria.invernadero_a.gid;


--
-- TOC entry 386 (class 1259 OID 2455802)
-- Name: acera_a; Type: TABLE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE TABLE it_asociado_transportacion.acera_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ035'::character varying NOT NULL,
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ035'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_asociado_transportacion.acera_a OWNER TO postgres;

--
-- TOC entry 7500 (class 0 OID 0)
-- Dependencies: 386
-- Name: TABLE acera_a; Type: COMMENT; Schema: it_asociado_transportacion; Owner: postgres
--

COMMENT ON TABLE it_asociado_transportacion.acera_a IS 'Ruta pavimentada o mejorada para uso del peatón, normalmente se encuentra adyacente y paralela a una calle o carretera. ';


--
-- TOC entry 387 (class 1259 OID 2455813)
-- Name: acera_a_gid_seq; Type: SEQUENCE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE SEQUENCE it_asociado_transportacion.acera_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_asociado_transportacion.acera_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7501 (class 0 OID 0)
-- Dependencies: 387
-- Name: acera_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER SEQUENCE it_asociado_transportacion.acera_a_gid_seq OWNED BY it_asociado_transportacion.acera_a.gid;


--
-- TOC entry 388 (class 1259 OID 2455814)
-- Name: bordillo_l; Type: TABLE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE TABLE it_asociado_transportacion.bordillo_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ037'::character varying NOT NULL,
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ037'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_asociado_transportacion.bordillo_l OWNER TO postgres;

--
-- TOC entry 7502 (class 0 OID 0)
-- Dependencies: 388
-- Name: TABLE bordillo_l; Type: COMMENT; Schema: it_asociado_transportacion; Owner: postgres
--

COMMENT ON TABLE it_asociado_transportacion.bordillo_l IS 'Borde de hormigón, asfalto o piedras que forman el borde de una acera a lo largo de la orilla de una calle o carretera. Se debe incluir aquellos que formen parte de los parterres.';


--
-- TOC entry 389 (class 1259 OID 2455825)
-- Name: bordillo_l_gid_seq; Type: SEQUENCE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE SEQUENCE it_asociado_transportacion.bordillo_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_asociado_transportacion.bordillo_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7503 (class 0 OID 0)
-- Dependencies: 389
-- Name: bordillo_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER SEQUENCE it_asociado_transportacion.bordillo_l_gid_seq OWNED BY it_asociado_transportacion.bordillo_l.gid;


--
-- TOC entry 390 (class 1259 OID 2455826)
-- Name: cuneta_a; Type: TABLE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE TABLE it_asociado_transportacion.cuneta_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ036'::character varying NOT NULL,
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry(MultiPolygon,32618) NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ036'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_asociado_transportacion.cuneta_a OWNER TO postgres;

--
-- TOC entry 7504 (class 0 OID 0)
-- Dependencies: 390
-- Name: TABLE cuneta_a; Type: COMMENT; Schema: it_asociado_transportacion; Owner: postgres
--

COMMENT ON TABLE it_asociado_transportacion.cuneta_a IS 'Borde de hormigón, asfalto o piedras que forman parte de un canal a lo largo del borde de una calle o carretera. Este objeto tiene el fin de canalizar agua de lluvia que se escurra a lo largo de la vía.';


--
-- TOC entry 391 (class 1259 OID 2455837)
-- Name: cuneta_a_gid_seq; Type: SEQUENCE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE SEQUENCE it_asociado_transportacion.cuneta_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_asociado_transportacion.cuneta_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7505 (class 0 OID 0)
-- Dependencies: 391
-- Name: cuneta_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER SEQUENCE it_asociado_transportacion.cuneta_a_gid_seq OWNED BY it_asociado_transportacion.cuneta_a.gid;


--
-- TOC entry 392 (class 1259 OID 2455838)
-- Name: parqueadero_a; Type: TABLE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE TABLE it_asociado_transportacion.parqueadero_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ140'::character varying NOT NULL,
    nam character varying(80),
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ140'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_asociado_transportacion.parqueadero_a OWNER TO postgres;

--
-- TOC entry 7506 (class 0 OID 0)
-- Dependencies: 392
-- Name: TABLE parqueadero_a; Type: COMMENT; Schema: it_asociado_transportacion; Owner: postgres
--

COMMENT ON TABLE it_asociado_transportacion.parqueadero_a IS 'Lugar destinado generalmente para estacionar vehículos.';


--
-- TOC entry 393 (class 1259 OID 2455849)
-- Name: parqueadero_a_gid_seq; Type: SEQUENCE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE SEQUENCE it_asociado_transportacion.parqueadero_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_asociado_transportacion.parqueadero_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7507 (class 0 OID 0)
-- Dependencies: 393
-- Name: parqueadero_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER SEQUENCE it_asociado_transportacion.parqueadero_a_gid_seq OWNED BY it_asociado_transportacion.parqueadero_a.gid;


--
-- TOC entry 394 (class 1259 OID 2455850)
-- Name: paseo_peatonal_ciclovia_a; Type: TABLE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE TABLE it_asociado_transportacion.paseo_peatonal_ciclovia_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AP031'::character varying NOT NULL,
    nam character varying(80),
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AP031'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_asociado_transportacion.paseo_peatonal_ciclovia_a OWNER TO postgres;

--
-- TOC entry 7508 (class 0 OID 0)
-- Dependencies: 394
-- Name: TABLE paseo_peatonal_ciclovia_a; Type: COMMENT; Schema: it_asociado_transportacion; Owner: postgres
--

COMMENT ON TABLE it_asociado_transportacion.paseo_peatonal_ciclovia_a IS 'Franja de terreno pavimentada o mejorada que tiene por objeto servir como una vía para peatones, animales y/o vehículos no motorizado.';


--
-- TOC entry 395 (class 1259 OID 2455861)
-- Name: paseo_peatonal_ciclovia_a_gid_seq; Type: SEQUENCE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE SEQUENCE it_asociado_transportacion.paseo_peatonal_ciclovia_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_asociado_transportacion.paseo_peatonal_ciclovia_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7509 (class 0 OID 0)
-- Dependencies: 395
-- Name: paseo_peatonal_ciclovia_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER SEQUENCE it_asociado_transportacion.paseo_peatonal_ciclovia_a_gid_seq OWNED BY it_asociado_transportacion.paseo_peatonal_ciclovia_a.gid;


--
-- TOC entry 396 (class 1259 OID 2455862)
-- Name: tunel_a; Type: TABLE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE TABLE it_asociado_transportacion.tunel_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ130'::character varying NOT NULL,
    nam character varying(80),
    tra integer NOT NULL,
    tuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry(MultiPolygon,32618) NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ130'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_asociado_transportacion.tunel_a OWNER TO postgres;

--
-- TOC entry 7510 (class 0 OID 0)
-- Dependencies: 396
-- Name: TABLE tunel_a; Type: COMMENT; Schema: it_asociado_transportacion; Owner: postgres
--

COMMENT ON TABLE it_asociado_transportacion.tunel_a IS 'Paso subterráneo o submarino, abierto para establecer comunicación.';


--
-- TOC entry 397 (class 1259 OID 2455873)
-- Name: tunel_a_gid_seq; Type: SEQUENCE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE SEQUENCE it_asociado_transportacion.tunel_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_asociado_transportacion.tunel_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7511 (class 0 OID 0)
-- Dependencies: 397
-- Name: tunel_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER SEQUENCE it_asociado_transportacion.tunel_a_gid_seq OWNED BY it_asociado_transportacion.tunel_a.gid;


--
-- TOC entry 398 (class 1259 OID 2455874)
-- Name: puente_a; Type: TABLE; Schema: it_cruces_enlaces; Owner: postgres
--

CREATE TABLE it_cruces_enlaces.puente_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ040'::character varying NOT NULL,
    nam character varying(80),
    na2 character varying(80),
    acc integer NOT NULL,
    bsc integer NOT NULL,
    ltn integer NOT NULL,
    typ integer NOT NULL,
    tuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ040'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_cruces_enlaces.puente_a OWNER TO postgres;

--
-- TOC entry 7512 (class 0 OID 0)
-- Dependencies: 398
-- Name: TABLE puente_a; Type: COMMENT; Schema: it_cruces_enlaces; Owner: postgres
--

COMMENT ON TABLE it_cruces_enlaces.puente_a IS 'Estructura que conecta dos lugares y facilita el paso de una ruta de transporte (por ejemplo: carretera o ferrocarril) sobre un obstáculo del terreno (por ejemplo: cuerpo de agua, barranco y/o carretera).';


--
-- TOC entry 399 (class 1259 OID 2455885)
-- Name: puente_a_gid_seq; Type: SEQUENCE; Schema: it_cruces_enlaces; Owner: postgres
--

CREATE SEQUENCE it_cruces_enlaces.puente_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_cruces_enlaces.puente_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7513 (class 0 OID 0)
-- Dependencies: 399
-- Name: puente_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER SEQUENCE it_cruces_enlaces.puente_a_gid_seq OWNED BY it_cruces_enlaces.puente_a.gid;


--
-- TOC entry 400 (class 1259 OID 2455886)
-- Name: ferrocarril_a; Type: TABLE; Schema: it_ferrocarriles; Owner: postgres
--

CREATE TABLE it_ferrocarriles.ferrocarril_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AN010'::character varying NOT NULL,
    nam character varying(80),
    acc integer NOT NULL,
    fco integer NOT NULL,
    loc integer NOT NULL,
    ltn integer NOT NULL,
    rgc integer NOT NULL,
    rra integer NOT NULL,
    rrc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry(MultiPolygon,32618) NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AN010'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_ferrocarriles.ferrocarril_a OWNER TO postgres;

--
-- TOC entry 7514 (class 0 OID 0)
-- Dependencies: 400
-- Name: TABLE ferrocarril_a; Type: COMMENT; Schema: it_ferrocarriles; Owner: postgres
--

COMMENT ON TABLE it_ferrocarriles.ferrocarril_a IS 'Una o más vías de ferrocarril que comprende una red utilizada para el transporte de pasajeros y/o bienes.';


--
-- TOC entry 401 (class 1259 OID 2455897)
-- Name: ferrocarril_a_gid_seq; Type: SEQUENCE; Schema: it_ferrocarriles; Owner: postgres
--

CREATE SEQUENCE it_ferrocarriles.ferrocarril_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_ferrocarriles.ferrocarril_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7515 (class 0 OID 0)
-- Dependencies: 401
-- Name: ferrocarril_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_ferrocarriles; Owner: postgres
--

ALTER SEQUENCE it_ferrocarriles.ferrocarril_a_gid_seq OWNED BY it_ferrocarriles.ferrocarril_a.gid;


--
-- TOC entry 402 (class 1259 OID 2455898)
-- Name: gasolinera_a; Type: TABLE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE TABLE it_transporte_terrestre.gasolinera_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ170'::character varying NOT NULL,
    nam character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ170'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_transporte_terrestre.gasolinera_a OWNER TO postgres;

--
-- TOC entry 7516 (class 0 OID 0)
-- Dependencies: 402
-- Name: TABLE gasolinera_a; Type: COMMENT; Schema: it_transporte_terrestre; Owner: postgres
--

COMMENT ON TABLE it_transporte_terrestre.gasolinera_a IS 'Establecimiento en el cual se vende combustible y lubricantes generalmente para vehículos de motor.';


--
-- TOC entry 403 (class 1259 OID 2455909)
-- Name: gasolinera_a_gid_seq; Type: SEQUENCE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE SEQUENCE it_transporte_terrestre.gasolinera_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_transporte_terrestre.gasolinera_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7517 (class 0 OID 0)
-- Dependencies: 403
-- Name: gasolinera_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER SEQUENCE it_transporte_terrestre.gasolinera_a_gid_seq OWNED BY it_transporte_terrestre.gasolinera_a.gid;


--
-- TOC entry 404 (class 1259 OID 2455910)
-- Name: intercambiador_vial_a; Type: TABLE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE TABLE it_transporte_terrestre.intercambiador_vial_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AP020'::character varying NOT NULL,
    nam character varying(80),
    hct integer NOT NULL,
    rst integer NOT NULL,
    loc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AP020'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_transporte_terrestre.intercambiador_vial_a OWNER TO postgres;

--
-- TOC entry 7518 (class 0 OID 0)
-- Dependencies: 404
-- Name: TABLE intercambiador_vial_a; Type: COMMENT; Schema: it_transporte_terrestre; Owner: postgres
--

COMMENT ON TABLE it_transporte_terrestre.intercambiador_vial_a IS 'Conexión diseñada para facilitar el acceso del tráfico de una carretera a otra.';


--
-- TOC entry 405 (class 1259 OID 2455921)
-- Name: intercambiador_vial_a_gid_seq; Type: SEQUENCE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE SEQUENCE it_transporte_terrestre.intercambiador_vial_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_transporte_terrestre.intercambiador_vial_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7519 (class 0 OID 0)
-- Dependencies: 405
-- Name: intercambiador_vial_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER SEQUENCE it_transporte_terrestre.intercambiador_vial_a_gid_seq OWNED BY it_transporte_terrestre.intercambiador_vial_a.gid;


--
-- TOC entry 406 (class 1259 OID 2455922)
-- Name: rodera_l; Type: TABLE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE TABLE it_transporte_terrestre.rodera_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AP010'::character varying NOT NULL,
    typ integer NOT NULL,
    rst integer NOT NULL,
    hct integer NOT NULL,
    rdt integer,
    wtc integer NOT NULL,
    ltn integer NOT NULL,
    tuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AP010'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_transporte_terrestre.rodera_l OWNER TO postgres;

--
-- TOC entry 7520 (class 0 OID 0)
-- Dependencies: 406
-- Name: TABLE rodera_l; Type: COMMENT; Schema: it_transporte_terrestre; Owner: postgres
--

COMMENT ON TABLE it_transporte_terrestre.rodera_l IS 'Vía natural con poca o ninguna mejora por la que pueden transitar vehículos de doble tracción.';


--
-- TOC entry 407 (class 1259 OID 2455933)
-- Name: rodera_l_gid_seq; Type: SEQUENCE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE SEQUENCE it_transporte_terrestre.rodera_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_transporte_terrestre.rodera_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7521 (class 0 OID 0)
-- Dependencies: 407
-- Name: rodera_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER SEQUENCE it_transporte_terrestre.rodera_l_gid_seq OWNED BY it_transporte_terrestre.rodera_l.gid;


--
-- TOC entry 408 (class 1259 OID 2455934)
-- Name: sendero_l; Type: TABLE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE TABLE it_transporte_terrestre.sendero_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AP050'::character varying NOT NULL,
    wtc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AP050'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_transporte_terrestre.sendero_l OWNER TO postgres;

--
-- TOC entry 7522 (class 0 OID 0)
-- Dependencies: 408
-- Name: TABLE sendero_l; Type: COMMENT; Schema: it_transporte_terrestre; Owner: postgres
--

COMMENT ON TABLE it_transporte_terrestre.sendero_l IS 'Camino angosto abierto por el tránsito de personas o animales.';


--
-- TOC entry 409 (class 1259 OID 2455945)
-- Name: sendero_l_gid_seq; Type: SEQUENCE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE SEQUENCE it_transporte_terrestre.sendero_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_transporte_terrestre.sendero_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7523 (class 0 OID 0)
-- Dependencies: 409
-- Name: sendero_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER SEQUENCE it_transporte_terrestre.sendero_l_gid_seq OWNED BY it_transporte_terrestre.sendero_l.gid;


--
-- TOC entry 410 (class 1259 OID 2455946)
-- Name: via_ruta_a; Type: TABLE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE TABLE it_transporte_terrestre.via_ruta_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AP030'::character varying NOT NULL,
    nam character varying(80),
    na2 character varying(80),
    acc integer NOT NULL,
    rst integer NOT NULL,
    typ integer NOT NULL,
    hct integer NOT NULL,
    loc integer NOT NULL,
    ltn integer NOT NULL,
    mes integer NOT NULL,
    rdt integer,
    tuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AP030'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_transporte_terrestre.via_ruta_a OWNER TO postgres;

--
-- TOC entry 7524 (class 0 OID 0)
-- Dependencies: 410
-- Name: TABLE via_ruta_a; Type: COMMENT; Schema: it_transporte_terrestre; Owner: postgres
--

COMMENT ON TABLE it_transporte_terrestre.via_ruta_a IS 'Trayecto con una superficie especialmente preparada que se mantiene para ser usada por vehículos generalmente a motor. ';


--
-- TOC entry 411 (class 1259 OID 2455957)
-- Name: via_ruta_a_gid_seq; Type: SEQUENCE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE SEQUENCE it_transporte_terrestre.via_ruta_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_transporte_terrestre.via_ruta_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7525 (class 0 OID 0)
-- Dependencies: 411
-- Name: via_ruta_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER SEQUENCE it_transporte_terrestre.via_ruta_a_gid_seq OWNED BY it_transporte_terrestre.via_ruta_a.gid;


--
-- TOC entry 412 (class 1259 OID 2455958)
-- Name: qgis_projects; Type: TABLE; Schema: proyecto_qgis3; Owner: postgres
--

CREATE TABLE proyecto_qgis3.qgis_projects (
    name text NOT NULL,
    metadata jsonb,
    content bytea
);


ALTER TABLE proyecto_qgis3.qgis_projects OWNER TO postgres;

--
-- TOC entry 413 (class 1259 OID 2455963)
-- Name: acequia_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.acequia_l AS
 SELECT acequia_l.gid,
    acequia_l.fcode,
    catalogo_objetos.descripcion,
    hyp.hyp_desc,
    dit.dit_desc,
    acequia_l.txt,
    (acequia_l.the_geom)::public.geometry(LineString,32618) AS the_geom
   FROM (((ho_aguas_interiores.acequia_l
     JOIN catalogo_objetos.hyp ON ((acequia_l.hyp = hyp.hyp)))
     JOIN catalogo_objetos.dit ON ((acequia_l.dit = dit.dit)))
     JOIN catalogo_objetos.catalogo_objetos ON (((acequia_l.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.acequia_l OWNER TO postgres;

--
-- TOC entry 414 (class 1259 OID 2455968)
-- Name: acera_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.acera_a AS
 SELECT acera_a.gid,
    acera_a.fcode,
    catalogo_objetos.descripcion,
    smc.smc_desc,
    acera_a.txt,
    (acera_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM ((it_asociado_transportacion.acera_a
     JOIN catalogo_objetos.catalogo_objetos ON (((acera_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((acera_a.smc = smc.smc)));


ALTER TABLE visualizacion.acera_a OWNER TO postgres;

--
-- TOC entry 415 (class 1259 OID 2455973)
-- Name: acueducto_canal_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.acueducto_canal_a AS
 SELECT acueducto_canal_a.gid,
    acueducto_canal_a.fcode,
    catalogo_objetos.descripcion,
    atc.atc_desc,
    smc.smc_desc,
    acueducto_canal_a.txt,
    (acueducto_canal_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM (((ho_aguas_interiores.acueducto_canal_a
     JOIN catalogo_objetos.catalogo_objetos ON (((acueducto_canal_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.atc ON ((acueducto_canal_a.atc = atc.atc)))
     JOIN catalogo_objetos.smc ON ((acueducto_canal_a.smc = smc.smc)));


ALTER TABLE visualizacion.acueducto_canal_a OWNER TO postgres;

--
-- TOC entry 416 (class 1259 OID 2455978)
-- Name: aeropuerto_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.aeropuerto_a AS
 SELECT aeropuerto_a.gid,
    aeropuerto_a.fcode,
    catalogo_objetos.descripcion,
    aeropuerto_a.nam,
    acc.acc_desc,
    aeropuerto_a.iko,
    fuc.fuc_desc,
    aeropuerto_a.txt,
    (aeropuerto_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM (((a_aeropuerto_superficie.aeropuerto_a
     JOIN catalogo_objetos.catalogo_objetos ON (((aeropuerto_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((aeropuerto_a.acc = acc.acc)))
     JOIN catalogo_objetos.fuc ON ((aeropuerto_a.fuc = fuc.fuc)));


ALTER TABLE visualizacion.aeropuerto_a OWNER TO postgres;

--
-- TOC entry 417 (class 1259 OID 2455983)
-- Name: bordillo_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.bordillo_l AS
 SELECT bordillo_l.gid,
    bordillo_l.fcode,
    catalogo_objetos.descripcion,
    smc.smc_desc,
    bordillo_l.txt,
    (bordillo_l.the_geom)::public.geometry(LineString,32618) AS the_geom
   FROM ((it_asociado_transportacion.bordillo_l
     JOIN catalogo_objetos.catalogo_objetos ON (((bordillo_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((bordillo_l.smc = smc.smc)));


ALTER TABLE visualizacion.bordillo_l OWNER TO postgres;

--
-- TOC entry 418 (class 1259 OID 2455988)
-- Name: cancha_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.cancha_a AS
 SELECT cancha_a.gid,
    cancha_a.fcode,
    catalogo_objetos.descripcion,
    cancha_a.nam,
    smc.smc_desc,
    kos.kos_desc,
    cancha_a.txt,
    (cancha_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM (((gs_recreacion.cancha_a
     JOIN catalogo_objetos.catalogo_objetos ON (((cancha_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((cancha_a.smc = smc.smc)))
     JOIN catalogo_objetos.kos ON ((cancha_a.kos = kos.kos)));


ALTER TABLE visualizacion.cancha_a OWNER TO postgres;

--
-- TOC entry 419 (class 1259 OID 2455993)
-- Name: cementerio_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.cementerio_a AS
 SELECT cementerio_a.gid,
    cementerio_a.fcode,
    catalogo_objetos.descripcion,
    cementerio_a.nam,
    rel.rel_desc,
    cementerio_a.txt,
    (cementerio_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM ((gs_asociado_poblados.cementerio_a
     JOIN catalogo_objetos.catalogo_objetos ON (((cementerio_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.rel ON ((cementerio_a.rel = rel.rel)));


ALTER TABLE visualizacion.cementerio_a OWNER TO postgres;

--
-- TOC entry 420 (class 1259 OID 2455998)
-- Name: cerca_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.cerca_l AS
 SELECT cerca_l.gid,
    cerca_l.fcode,
    catalogo_objetos.descripcion,
    fti.fti_desc,
    wti.wti_desc,
    cerca_l.txt,
    (cerca_l.the_geom)::public.geometry(LineString,32618) AS the_geom
   FROM (((gs_asociado_poblados.cerca_l
     JOIN catalogo_objetos.catalogo_objetos ON (((cerca_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.fti ON ((cerca_l.fti = fti.fti)))
     JOIN catalogo_objetos.wti ON ((cerca_l.wti = wti.wti)));


ALTER TABLE visualizacion.cerca_l OWNER TO postgres;

--
-- TOC entry 421 (class 1259 OID 2456003)
-- Name: cuneta_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.cuneta_a AS
 SELECT cuneta_a.gid,
    cuneta_a.fcode,
    catalogo_objetos.descripcion,
    smc.smc_desc,
    cuneta_a.txt,
    cuneta_a.the_geom
   FROM ((it_asociado_transportacion.cuneta_a
     JOIN catalogo_objetos.catalogo_objetos ON (((cuneta_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((cuneta_a.smc = smc.smc)));


ALTER TABLE visualizacion.cuneta_a OWNER TO postgres;

--
-- TOC entry 422 (class 1259 OID 2456007)
-- Name: edificio_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.edificio_a AS
 SELECT edificio_a.gid,
    edificio_a.fcode,
    catalogo_objetos.descripcion,
    edificio_a.nam,
    acc.acc_desc,
    uuc.uuc_desc,
    edificio_a.txt,
    (edificio_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM (((gs_construcciones.edificio_a
     JOIN catalogo_objetos.catalogo_objetos ON (((edificio_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((edificio_a.acc = acc.acc)))
     JOIN catalogo_objetos.uuc ON ((edificio_a.uuc = uuc.uuc)));


ALTER TABLE visualizacion.edificio_a OWNER TO postgres;

--
-- TOC entry 423 (class 1259 OID 2456012)
-- Name: escalinata_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.escalinata_a AS
 SELECT escalinata_a.gid,
    escalinata_a.fcode,
    catalogo_objetos.descripcion,
    smc.smc_desc,
    escalinata_a.txt,
    (escalinata_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM ((gs_asociado_poblados.escalinata_a
     JOIN catalogo_objetos.catalogo_objetos ON (((escalinata_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((escalinata_a.smc = smc.smc)));


ALTER TABLE visualizacion.escalinata_a OWNER TO postgres;

--
-- TOC entry 424 (class 1259 OID 2456017)
-- Name: estadio_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.estadio_a AS
 SELECT estadio_a.gid,
    estadio_a.fcode,
    catalogo_objetos.descripcion,
    estadio_a.nam,
    acc.acc_desc,
    estadio_a.txt,
    (estadio_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM ((gs_recreacion.estadio_a
     JOIN catalogo_objetos.catalogo_objetos ON (((estadio_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((estadio_a.acc = acc.acc)));


ALTER TABLE visualizacion.estadio_a OWNER TO postgres;

--
-- TOC entry 425 (class 1259 OID 2456022)
-- Name: ferrocarril_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.ferrocarril_a AS
 SELECT ferrocarril_a.gid,
    ferrocarril_a.fcode,
    catalogo_objetos.descripcion,
    ferrocarril_a.nam,
    acc.acc_desc,
    fco.fco_desc,
    loc.loc_desc,
    ferrocarril_a.ltn,
    rgc.rgc_desc,
    rra.rra_desc,
    rrc.rrc_desc,
    ferrocarril_a.txt,
    ferrocarril_a.the_geom
   FROM (((((((it_ferrocarriles.ferrocarril_a
     JOIN catalogo_objetos.catalogo_objetos ON (((ferrocarril_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((ferrocarril_a.acc = acc.acc)))
     JOIN catalogo_objetos.fco ON ((ferrocarril_a.fco = fco.fco)))
     JOIN catalogo_objetos.loc ON ((ferrocarril_a.loc = loc.loc)))
     JOIN catalogo_objetos.rgc ON ((ferrocarril_a.rgc = rgc.rgc)))
     JOIN catalogo_objetos.rra ON ((ferrocarril_a.rra = rra.rra)))
     JOIN catalogo_objetos.rrc ON ((ferrocarril_a.rrc = rrc.rrc)));


ALTER TABLE visualizacion.ferrocarril_a OWNER TO postgres;

--
-- TOC entry 426 (class 1259 OID 2456027)
-- Name: gasolinera_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.gasolinera_a AS
 SELECT gasolinera_a.gid,
    gasolinera_a.fcode,
    catalogo_objetos.descripcion,
    gasolinera_a.nam,
    gasolinera_a.txt,
    (gasolinera_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM (it_transporte_terrestre.gasolinera_a
     JOIN catalogo_objetos.catalogo_objetos ON (((gasolinera_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.gasolinera_a OWNER TO postgres;

--
-- TOC entry 427 (class 1259 OID 2456031)
-- Name: granja_acuatica_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.granja_acuatica_a AS
 SELECT granja_acuatica_a.gid,
    granja_acuatica_a.fcode,
    catalogo_objetos.descripcion,
    granja_acuatica_a.txt,
    (granja_acuatica_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM (ho_regulacion_zonas_restringidas.granja_acuatica_a
     JOIN catalogo_objetos.catalogo_objetos ON (((granja_acuatica_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.granja_acuatica_a OWNER TO postgres;

--
-- TOC entry 428 (class 1259 OID 2456035)
-- Name: intercambiador_vial_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.intercambiador_vial_a AS
 SELECT intercambiador_vial_a.gid,
    intercambiador_vial_a.fcode,
    catalogo_objetos.descripcion,
    intercambiador_vial_a.nam,
    hct.hct_desc,
    rst.rst_desc,
    loc.loc_desc,
    intercambiador_vial_a.txt,
    (intercambiador_vial_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM ((((it_transporte_terrestre.intercambiador_vial_a
     JOIN catalogo_objetos.catalogo_objetos ON (((intercambiador_vial_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.hct ON ((intercambiador_vial_a.hct = hct.hct)))
     JOIN catalogo_objetos.rst ON ((intercambiador_vial_a.rst = rst.rst)))
     JOIN catalogo_objetos.loc ON ((intercambiador_vial_a.loc = loc.loc)));


ALTER TABLE visualizacion.intercambiador_vial_a OWNER TO postgres;

--
-- TOC entry 429 (class 1259 OID 2456040)
-- Name: invernadero_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.invernadero_a AS
 SELECT invernadero_a.gid,
    invernadero_a.fcode,
    catalogo_objetos.descripcion,
    invernadero_a.nam,
    invernadero_a.txt,
    (invernadero_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM (ii_agropecuaria.invernadero_a
     JOIN catalogo_objetos.catalogo_objetos ON (((invernadero_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.invernadero_a OWNER TO postgres;

--
-- TOC entry 430 (class 1259 OID 2456044)
-- Name: isla_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.isla_a AS
 SELECT isla_a.gid,
    isla_a.fcode,
    catalogo_objetos.descripcion,
    isla_a.nam,
    isla_a.na2,
    isla_a.txt,
    (isla_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM (ho_zonas_costeras.isla_a
     JOIN catalogo_objetos.catalogo_objetos ON (((isla_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.isla_a OWNER TO postgres;

--
-- TOC entry 431 (class 1259 OID 2456048)
-- Name: lago_laguna_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.lago_laguna_a AS
 SELECT lago_laguna_a.gid,
    lago_laguna_a.fcode,
    catalogo_objetos.descripcion,
    lago_laguna_a.nam,
    lago_laguna_a.na2,
    hyp.hyp_desc,
    lago_laguna_a.txt,
    (lago_laguna_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM ((ho_aguas_interiores.lago_laguna_a
     JOIN catalogo_objetos.catalogo_objetos ON (((lago_laguna_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.hyp ON ((lago_laguna_a.hyp = hyp.hyp)));


ALTER TABLE visualizacion.lago_laguna_a OWNER TO postgres;

--
-- TOC entry 432 (class 1259 OID 2456053)
-- Name: muro_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.muro_l AS
 SELECT muro_l.gid,
    muro_l.fcode,
    catalogo_objetos.descripcion,
    wti.wti_desc,
    muro_l.txt,
    (muro_l.the_geom)::public.geometry(LineString,32618) AS the_geom
   FROM ((gs_asociado_poblados.muro_l
     JOIN catalogo_objetos.catalogo_objetos ON (((muro_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.wti ON ((muro_l.wti = wti.wti)));


ALTER TABLE visualizacion.muro_l OWNER TO postgres;

--
-- TOC entry 433 (class 1259 OID 2456058)
-- Name: orilla_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.orilla_l AS
 SELECT orilla_l.gid,
    orilla_l.fcode,
    catalogo_objetos.descripcion,
    acc.acc_desc,
    slt.slt_desc,
    orilla_l.txt,
    (orilla_l.the_geom)::public.geometry(LineString,32618) AS the_geom
   FROM (((ho_zonas_costeras.orilla_l
     JOIN catalogo_objetos.catalogo_objetos ON (((orilla_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((orilla_l.acc = acc.acc)))
     JOIN catalogo_objetos.slt ON ((orilla_l.slt = slt.slt)));


ALTER TABLE visualizacion.orilla_l OWNER TO postgres;

--
-- TOC entry 434 (class 1259 OID 2456063)
-- Name: parque_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.parque_a AS
 SELECT parque_a.gid,
    parque_a.fcode,
    catalogo_objetos.descripcion,
    parque_a.nam,
    fuc.fuc_desc,
    parque_a.txt,
    (parque_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM ((gs_recreacion.parque_a
     JOIN catalogo_objetos.catalogo_objetos ON (((parque_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.fuc ON ((parque_a.fuc = fuc.fuc)));


ALTER TABLE visualizacion.parque_a OWNER TO postgres;

--
-- TOC entry 435 (class 1259 OID 2456068)
-- Name: parqueadero_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.parqueadero_a AS
 SELECT parqueadero_a.gid,
    parqueadero_a.fcode,
    catalogo_objetos.descripcion,
    parqueadero_a.nam,
    smc.smc_desc,
    parqueadero_a.txt,
    (parqueadero_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM ((it_asociado_transportacion.parqueadero_a
     JOIN catalogo_objetos.catalogo_objetos ON (((parqueadero_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((parqueadero_a.smc = smc.smc)));


ALTER TABLE visualizacion.parqueadero_a OWNER TO postgres;

--
-- TOC entry 436 (class 1259 OID 2456073)
-- Name: paseo_peatonal_ciclovia_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.paseo_peatonal_ciclovia_a AS
 SELECT paseo_peatonal_ciclovia_a.gid,
    paseo_peatonal_ciclovia_a.fcode,
    catalogo_objetos.descripcion,
    paseo_peatonal_ciclovia_a.nam,
    smc.smc_desc,
    paseo_peatonal_ciclovia_a.txt,
    (paseo_peatonal_ciclovia_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM ((it_asociado_transportacion.paseo_peatonal_ciclovia_a
     JOIN catalogo_objetos.catalogo_objetos ON (((paseo_peatonal_ciclovia_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((paseo_peatonal_ciclovia_a.smc = smc.smc)));


ALTER TABLE visualizacion.paseo_peatonal_ciclovia_a OWNER TO postgres;

--
-- TOC entry 437 (class 1259 OID 2456078)
-- Name: piscina_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.piscina_a AS
 SELECT piscina_a.gid,
    piscina_a.fcode,
    catalogo_objetos.descripcion,
    piscina_a.nam,
    piscina_a.txt,
    (piscina_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM (gs_recreacion.piscina_a
     JOIN catalogo_objetos.catalogo_objetos ON (((piscina_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.piscina_a OWNER TO postgres;

--
-- TOC entry 438 (class 1259 OID 2456082)
-- Name: plaza_publica_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.plaza_publica_a AS
 SELECT plaza_publica_a.gid,
    plaza_publica_a.fcode,
    catalogo_objetos.descripcion,
    plaza_publica_a.nam,
    smc.smc_desc,
    plaza_publica_a.txt,
    (plaza_publica_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM ((gs_asociado_poblados.plaza_publica_a
     JOIN catalogo_objetos.catalogo_objetos ON (((plaza_publica_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((plaza_publica_a.smc = smc.smc)));


ALTER TABLE visualizacion.plaza_publica_a OWNER TO postgres;

--
-- TOC entry 439 (class 1259 OID 2456087)
-- Name: plaza_toros_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.plaza_toros_a AS
 SELECT plaza_toros_a.gid,
    plaza_toros_a.fcode,
    catalogo_objetos.descripcion,
    plaza_toros_a.nam,
    plaza_toros_a.txt,
    (plaza_toros_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM (gs_recreacion.plaza_toros_a
     JOIN catalogo_objetos.catalogo_objetos ON (((plaza_toros_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.plaza_toros_a OWNER TO postgres;

--
-- TOC entry 440 (class 1259 OID 2456091)
-- Name: puente_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.puente_a AS
 SELECT puente_a.gid,
    puente_a.fcode,
    catalogo_objetos.descripcion,
    puente_a.nam,
    puente_a.na2,
    acc.acc_desc,
    bsc.bsc_desc,
    puente_a.ltn,
    typ.typ_desc,
    tuc.tuc_desc,
    puente_a.txt,
    (puente_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM (((((it_cruces_enlaces.puente_a
     JOIN catalogo_objetos.catalogo_objetos ON (((puente_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((puente_a.acc = acc.acc)))
     JOIN catalogo_objetos.bsc ON ((puente_a.bsc = bsc.bsc)))
     JOIN catalogo_objetos.typ ON ((puente_a.typ = typ.typ)))
     JOIN catalogo_objetos.tuc ON ((puente_a.tuc = tuc.tuc)));


ALTER TABLE visualizacion.puente_a OWNER TO postgres;

--
-- TOC entry 441 (class 1259 OID 2456096)
-- Name: puerto_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.puerto_a AS
 SELECT puerto_a.gid,
    puerto_a.fcode,
    catalogo_objetos.descripcion,
    puerto_a.nam,
    puerto_a.txt,
    (puerto_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM (ho_puertos_muelles.puerto_a
     JOIN catalogo_objetos.catalogo_objetos ON (((puerto_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.puerto_a OWNER TO postgres;

--
-- TOC entry 442 (class 1259 OID 2456100)
-- Name: punto_control_p; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.punto_control_p AS
 SELECT punto_control_p.gid,
    punto_control_p.fcode,
    catalogo_objetos.descripcion,
    acc.acc_desc,
    ela.ela_desc,
    punto_control_p.zvh,
    punto_control_p.txt,
    (punto_control_p.the_geom)::public.geometry(Point,32618) AS the_geom
   FROM (((d_linderos_propiedad.punto_control_p
     JOIN catalogo_objetos.catalogo_objetos ON (((punto_control_p.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((punto_control_p.acc = acc.acc)))
     JOIN catalogo_objetos.ela ON ((punto_control_p.ela = ela.ela)));


ALTER TABLE visualizacion.punto_control_p OWNER TO postgres;

--
-- TOC entry 443 (class 1259 OID 2456105)
-- Name: rio_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.rio_a AS
 SELECT rio_a.gid,
    rio_a.fcode,
    catalogo_objetos.descripcion,
    rio_a.nam,
    rio_a.na2,
    acc.acc_desc,
    hyp.hyp_desc,
    rio_a.txt,
    (rio_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM (((catalogo_objetos.catalogo_objetos
     JOIN ho_aguas_interiores.rio_a ON (((catalogo_objetos.fcode)::text = (rio_a.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((rio_a.acc = acc.acc)))
     JOIN catalogo_objetos.hyp ON ((rio_a.hyp = hyp.hyp)));


ALTER TABLE visualizacion.rio_a OWNER TO postgres;

--
-- TOC entry 444 (class 1259 OID 2456110)
-- Name: rio_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.rio_l AS
 SELECT rio_l.gid,
    rio_l.fcode,
    catalogo_objetos.descripcion,
    rio_l.nam,
    rio_l.na2,
    acc.acc_desc,
    hyp.hyp_desc,
    rio_l.txt,
    (rio_l.the_geom)::public.geometry(LineString,32618) AS the_geom
   FROM (((catalogo_objetos.catalogo_objetos
     JOIN ho_aguas_interiores.rio_l ON (((catalogo_objetos.fcode)::text = (rio_l.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((rio_l.acc = acc.acc)))
     JOIN catalogo_objetos.hyp ON ((rio_l.hyp = hyp.hyp)));


ALTER TABLE visualizacion.rio_l OWNER TO postgres;

--
-- TOC entry 445 (class 1259 OID 2456115)
-- Name: rodera_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.rodera_l AS
 SELECT rodera_l.gid,
    rodera_l.fcode,
    catalogo_objetos.descripcion,
    typ.typ_desc,
    rst.rst_desc,
    hct.hct_desc,
    rdt.rdt_desc,
    wtc.wtc_desc,
    rodera_l.ltn,
    tuc.tuc_desc,
    rodera_l.txt,
    (rodera_l.the_geom)::public.geometry(LineString,32618) AS the_geom
   FROM (((((((it_transporte_terrestre.rodera_l
     JOIN catalogo_objetos.catalogo_objetos ON (((rodera_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.typ ON ((rodera_l.typ = typ.typ)))
     JOIN catalogo_objetos.hct ON ((rodera_l.hct = hct.hct)))
     JOIN catalogo_objetos.rst ON ((rodera_l.rst = rst.rst)))
     JOIN catalogo_objetos.rdt ON ((rodera_l.rdt = rdt.rdt)))
     JOIN catalogo_objetos.wtc ON ((rodera_l.wtc = wtc.wtc)))
     JOIN catalogo_objetos.tuc ON ((rodera_l.tuc = tuc.tuc)));


ALTER TABLE visualizacion.rodera_l OWNER TO postgres;

--
-- TOC entry 446 (class 1259 OID 2456120)
-- Name: sendero_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.sendero_l AS
 SELECT sendero_l.gid,
    sendero_l.fcode,
    catalogo_objetos.descripcion,
    wtc.wtc_desc,
    sendero_l.txt,
    (sendero_l.the_geom)::public.geometry(LineString,32618) AS the_geom
   FROM ((it_transporte_terrestre.sendero_l
     JOIN catalogo_objetos.catalogo_objetos ON (((sendero_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.wtc ON ((sendero_l.wtc = wtc.wtc)));


ALTER TABLE visualizacion.sendero_l OWNER TO postgres;

--
-- TOC entry 447 (class 1259 OID 2456125)
-- Name: tunel_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.tunel_a AS
 SELECT tunel_a.gid,
    tunel_a.fcode,
    catalogo_objetos.descripcion,
    tunel_a.nam,
    tra.tra_desc,
    tuc.tuc_desc,
    tunel_a.txt,
    tunel_a.the_geom
   FROM (((it_asociado_transportacion.tunel_a
     JOIN catalogo_objetos.catalogo_objetos ON (((tunel_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.tra ON ((tunel_a.tra = tra.tra)))
     JOIN catalogo_objetos.tuc ON ((tunel_a.tuc = tuc.tuc)));


ALTER TABLE visualizacion.tunel_a OWNER TO postgres;

--
-- TOC entry 448 (class 1259 OID 2456130)
-- Name: via_ruta_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.via_ruta_a AS
 SELECT via_ruta_a.gid,
    via_ruta_a.fcode,
    catalogo_objetos.descripcion,
    via_ruta_a.nam,
    via_ruta_a.na2,
    acc.acc_desc,
    rst.rst_desc,
    typ.typ_desc,
    hct.hct_desc,
    loc.loc_desc,
    via_ruta_a.ltn,
    mes.mes_desc,
    rdt.rdt_desc,
    tuc.tuc_desc,
    via_ruta_a.txt,
    (via_ruta_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM (((((((((it_transporte_terrestre.via_ruta_a
     JOIN catalogo_objetos.catalogo_objetos ON (((via_ruta_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((via_ruta_a.acc = acc.acc)))
     JOIN catalogo_objetos.rst ON ((via_ruta_a.rst = rst.rst)))
     JOIN catalogo_objetos.typ ON ((via_ruta_a.typ = typ.typ)))
     JOIN catalogo_objetos.hct ON ((via_ruta_a.hct = hct.hct)))
     JOIN catalogo_objetos.loc ON ((via_ruta_a.loc = loc.loc)))
     JOIN catalogo_objetos.mes ON ((via_ruta_a.mes = mes.mes)))
     JOIN catalogo_objetos.rdt ON ((via_ruta_a.rdt = rdt.rdt)))
     JOIN catalogo_objetos.tuc ON ((via_ruta_a.tuc = tuc.tuc)));


ALTER TABLE visualizacion.via_ruta_a OWNER TO postgres;

--
-- TOC entry 449 (class 1259 OID 2456135)
-- Name: zanja_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.zanja_l AS
 SELECT zanja_l.gid,
    zanja_l.fcode,
    catalogo_objetos.descripcion,
    hyp.hyp_desc,
    zanja_l.txt,
    (zanja_l.the_geom)::public.geometry(LineString,32618) AS the_geom
   FROM ((ho_aguas_interiores.zanja_l
     JOIN catalogo_objetos.catalogo_objetos ON (((zanja_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.hyp ON ((zanja_l.hyp = hyp.hyp)));


ALTER TABLE visualizacion.zanja_l OWNER TO postgres;

--
-- TOC entry 6464 (class 2604 OID 2456140)
-- Name: aeropuerto_a gid; Type: DEFAULT; Schema: a_aeropuerto_superficie; Owner: postgres
--

ALTER TABLE ONLY a_aeropuerto_superficie.aeropuerto_a ALTER COLUMN gid SET DEFAULT nextval('a_aeropuerto_superficie.aeropuerto_a_gid_seq'::regclass);


--
-- TOC entry 6470 (class 2604 OID 2456141)
-- Name: catalogo_objetos gid; Type: DEFAULT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.catalogo_objetos ALTER COLUMN gid SET DEFAULT nextval('catalogo_objetos.catalogo_objetos_gid_seq'::regclass);


--
-- TOC entry 6472 (class 2604 OID 2456142)
-- Name: punto_control_p gid; Type: DEFAULT; Schema: d_linderos_propiedad; Owner: postgres
--

ALTER TABLE ONLY d_linderos_propiedad.punto_control_p ALTER COLUMN gid SET DEFAULT nextval('d_linderos_propiedad.vertice_geodesico_p_gid_seq'::regclass);


--
-- TOC entry 6479 (class 2604 OID 2456143)
-- Name: cementerio_a gid; Type: DEFAULT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cementerio_a ALTER COLUMN gid SET DEFAULT nextval('gs_asociado_poblados.cementerio_a_gid_seq'::regclass);


--
-- TOC entry 6486 (class 2604 OID 2456144)
-- Name: cerca_l gid; Type: DEFAULT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cerca_l ALTER COLUMN gid SET DEFAULT nextval('gs_asociado_poblados.cerca_l_gid_seq'::regclass);


--
-- TOC entry 6493 (class 2604 OID 2456145)
-- Name: escalinata_a gid; Type: DEFAULT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.escalinata_a ALTER COLUMN gid SET DEFAULT nextval('gs_asociado_poblados.escalinata_a_gid_seq'::regclass);


--
-- TOC entry 6500 (class 2604 OID 2456146)
-- Name: muro_l gid; Type: DEFAULT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.muro_l ALTER COLUMN gid SET DEFAULT nextval('gs_asociado_poblados.muro_l_gid_seq'::regclass);


--
-- TOC entry 6507 (class 2604 OID 2456147)
-- Name: plaza_publica_a gid; Type: DEFAULT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.plaza_publica_a ALTER COLUMN gid SET DEFAULT nextval('gs_asociado_poblados.plaza_publica_a_gid_seq'::regclass);


--
-- TOC entry 6514 (class 2604 OID 2456148)
-- Name: edificio_a gid; Type: DEFAULT; Schema: gs_construcciones; Owner: postgres
--

ALTER TABLE ONLY gs_construcciones.edificio_a ALTER COLUMN gid SET DEFAULT nextval('gs_construcciones.edificio_a_gid_seq'::regclass);


--
-- TOC entry 6521 (class 2604 OID 2456149)
-- Name: cancha_a gid; Type: DEFAULT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.cancha_a ALTER COLUMN gid SET DEFAULT nextval('gs_recreacion.cancha_a_gid_seq'::regclass);


--
-- TOC entry 6528 (class 2604 OID 2456150)
-- Name: estadio_a gid; Type: DEFAULT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.estadio_a ALTER COLUMN gid SET DEFAULT nextval('gs_recreacion.estadio_a_gid_seq'::regclass);


--
-- TOC entry 6535 (class 2604 OID 2456151)
-- Name: parque_a gid; Type: DEFAULT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.parque_a ALTER COLUMN gid SET DEFAULT nextval('gs_recreacion.parque_a_gid_seq'::regclass);


--
-- TOC entry 6542 (class 2604 OID 2456152)
-- Name: piscina_a gid; Type: DEFAULT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.piscina_a ALTER COLUMN gid SET DEFAULT nextval('gs_recreacion.piscina_a_gid_seq'::regclass);


--
-- TOC entry 6549 (class 2604 OID 2456153)
-- Name: plaza_toros_a gid; Type: DEFAULT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.plaza_toros_a ALTER COLUMN gid SET DEFAULT nextval('gs_recreacion.plaza_toros_a_gid_seq'::regclass);


--
-- TOC entry 6556 (class 2604 OID 2456154)
-- Name: acequia_l gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acequia_l ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.acequia_l_gid_seq'::regclass);


--
-- TOC entry 6563 (class 2604 OID 2456155)
-- Name: acueducto_canal_a gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acueducto_canal_a ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.acueducto_canal_a_gid_seq'::regclass);


--
-- TOC entry 6570 (class 2604 OID 2456156)
-- Name: lago_laguna_a gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.lago_laguna_a ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.lago_laguna_a_gid_seq'::regclass);


--
-- TOC entry 6577 (class 2604 OID 2456157)
-- Name: rio_a gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_a ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.rio_a_gid_seq'::regclass);


--
-- TOC entry 6584 (class 2604 OID 2456158)
-- Name: rio_l gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_l ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.rio_l_gid_seq'::regclass);


--
-- TOC entry 6591 (class 2604 OID 2456159)
-- Name: zanja_l gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.zanja_l ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.zanja_l_gid_seq'::regclass);


--
-- TOC entry 6598 (class 2604 OID 2456160)
-- Name: puerto_a gid; Type: DEFAULT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.puerto_a ALTER COLUMN gid SET DEFAULT nextval('ho_puertos_muelles.puerto_a_gid_seq'::regclass);


--
-- TOC entry 6605 (class 2604 OID 2456161)
-- Name: granja_acuatica_a gid; Type: DEFAULT; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

ALTER TABLE ONLY ho_regulacion_zonas_restringidas.granja_acuatica_a ALTER COLUMN gid SET DEFAULT nextval('ho_regulacion_zonas_restringidas.granja_acuatica_a_gid_seq'::regclass);


--
-- TOC entry 6612 (class 2604 OID 2456162)
-- Name: isla_a gid; Type: DEFAULT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.isla_a ALTER COLUMN gid SET DEFAULT nextval('ho_zonas_costeras.isla_a_gid_seq'::regclass);


--
-- TOC entry 6619 (class 2604 OID 2456163)
-- Name: orilla_l gid; Type: DEFAULT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.orilla_l ALTER COLUMN gid SET DEFAULT nextval('ho_zonas_costeras.orilla_l_gid_seq'::regclass);


--
-- TOC entry 6633 (class 2604 OID 2456164)
-- Name: acera_a gid; Type: DEFAULT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.acera_a ALTER COLUMN gid SET DEFAULT nextval('it_asociado_transportacion.acera_a_gid_seq'::regclass);


--
-- TOC entry 6640 (class 2604 OID 2456165)
-- Name: bordillo_l gid; Type: DEFAULT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.bordillo_l ALTER COLUMN gid SET DEFAULT nextval('it_asociado_transportacion.bordillo_l_gid_seq'::regclass);


--
-- TOC entry 6647 (class 2604 OID 2456166)
-- Name: cuneta_a gid; Type: DEFAULT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.cuneta_a ALTER COLUMN gid SET DEFAULT nextval('it_asociado_transportacion.cuneta_a_gid_seq'::regclass);


--
-- TOC entry 6654 (class 2604 OID 2456167)
-- Name: parqueadero_a gid; Type: DEFAULT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.parqueadero_a ALTER COLUMN gid SET DEFAULT nextval('it_asociado_transportacion.parqueadero_a_gid_seq'::regclass);


--
-- TOC entry 6661 (class 2604 OID 2456168)
-- Name: paseo_peatonal_ciclovia_a gid; Type: DEFAULT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.paseo_peatonal_ciclovia_a ALTER COLUMN gid SET DEFAULT nextval('it_asociado_transportacion.paseo_peatonal_ciclovia_a_gid_seq'::regclass);


--
-- TOC entry 6668 (class 2604 OID 2456169)
-- Name: tunel_a gid; Type: DEFAULT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.tunel_a ALTER COLUMN gid SET DEFAULT nextval('it_asociado_transportacion.tunel_a_gid_seq'::regclass);


--
-- TOC entry 6675 (class 2604 OID 2456170)
-- Name: puente_a gid; Type: DEFAULT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a ALTER COLUMN gid SET DEFAULT nextval('it_cruces_enlaces.puente_a_gid_seq'::regclass);


--
-- TOC entry 6682 (class 2604 OID 2456171)
-- Name: ferrocarril_a gid; Type: DEFAULT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a ALTER COLUMN gid SET DEFAULT nextval('it_ferrocarriles.ferrocarril_a_gid_seq'::regclass);


--
-- TOC entry 6689 (class 2604 OID 2456172)
-- Name: gasolinera_a gid; Type: DEFAULT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.gasolinera_a ALTER COLUMN gid SET DEFAULT nextval('it_transporte_terrestre.gasolinera_a_gid_seq'::regclass);


--
-- TOC entry 6696 (class 2604 OID 2456173)
-- Name: intercambiador_vial_a gid; Type: DEFAULT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.intercambiador_vial_a ALTER COLUMN gid SET DEFAULT nextval('it_transporte_terrestre.intercambiador_vial_a_gid_seq'::regclass);


--
-- TOC entry 6703 (class 2604 OID 2456174)
-- Name: rodera_l gid; Type: DEFAULT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l ALTER COLUMN gid SET DEFAULT nextval('it_transporte_terrestre.rodera_l_gid_seq'::regclass);


--
-- TOC entry 6710 (class 2604 OID 2456175)
-- Name: sendero_l gid; Type: DEFAULT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.sendero_l ALTER COLUMN gid SET DEFAULT nextval('it_transporte_terrestre.sendero_l_gid_seq'::regclass);


--
-- TOC entry 6717 (class 2604 OID 2456176)
-- Name: via_ruta_a gid; Type: DEFAULT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a ALTER COLUMN gid SET DEFAULT nextval('it_transporte_terrestre.via_ruta_a_gid_seq'::regclass);


--
-- TOC entry 7334 (class 0 OID 2455428)
-- Dependencies: 309
-- Data for Name: aeropuerto_a; Type: TABLE DATA; Schema: a_aeropuerto_superficie; Owner: postgres
--



--
-- TOC entry 7336 (class 0 OID 2455440)
-- Dependencies: 311
-- Data for Name: acc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.acc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.acc VALUES (1, '1.- Exacta');
INSERT INTO catalogo_objetos.acc VALUES (2, '2.- Aproximada');
INSERT INTO catalogo_objetos.acc VALUES (3, '3.- Dudosa');
INSERT INTO catalogo_objetos.acc VALUES (7, '7.- Precisa');
INSERT INTO catalogo_objetos.acc VALUES (998, '998.- No aplica');


--
-- TOC entry 7337 (class 0 OID 2455443)
-- Dependencies: 312
-- Data for Name: atc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.atc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.atc VALUES (1, '1.- Pozo Qanat');
INSERT INTO catalogo_objetos.atc VALUES (3, '3.- Acueducto subterráneo');
INSERT INTO catalogo_objetos.atc VALUES (4, '4.- Bajo el agua');
INSERT INTO catalogo_objetos.atc VALUES (5, '5.- Superficie');
INSERT INTO catalogo_objetos.atc VALUES (998, '998.- No aplica');


--
-- TOC entry 7338 (class 0 OID 2455446)
-- Dependencies: 313
-- Data for Name: bsc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.bsc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.bsc VALUES (1, '1.- Arco abierto Spandrel');
INSERT INTO catalogo_objetos.bsc VALUES (2, '2.- Voladizo');
INSERT INTO catalogo_objetos.bsc VALUES (3, '3.- Cubierta');
INSERT INTO catalogo_objetos.bsc VALUES (5, '5.- Flotante');
INSERT INTO catalogo_objetos.bsc VALUES (6, '6.- De viga');
INSERT INTO catalogo_objetos.bsc VALUES (7, '7.- Torre de suspensión');
INSERT INTO catalogo_objetos.bsc VALUES (8, '8.- Entramado');
INSERT INTO catalogo_objetos.bsc VALUES (9, '9.- Suspensión');
INSERT INTO catalogo_objetos.bsc VALUES (12, '12.- Transportador');
INSERT INTO catalogo_objetos.bsc VALUES (15, '15.- De losa');
INSERT INTO catalogo_objetos.bsc VALUES (16, '16.- Viga y largero');
INSERT INTO catalogo_objetos.bsc VALUES (19, '19.- Cuerda del arco del puente');
INSERT INTO catalogo_objetos.bsc VALUES (22, '22.- Cubierto');
INSERT INTO catalogo_objetos.bsc VALUES (26, '26.- Arco cerrado spandrel');
INSERT INTO catalogo_objetos.bsc VALUES (27, '27.- Atirantado');
INSERT INTO catalogo_objetos.bsc VALUES (28, '28.- Viaducto');
INSERT INTO catalogo_objetos.bsc VALUES (31, '31.- Arco');
INSERT INTO catalogo_objetos.bsc VALUES (32, '32.- Caballete');
INSERT INTO catalogo_objetos.bsc VALUES (998, '998.- No aplica');


--
-- TOC entry 7339 (class 0 OID 2455449)
-- Dependencies: 314
-- Data for Name: catalogo_objetos; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AA051', 'Boca de Pozo', 'Equipo utilizado para mantener el control de un pozo, incluyen accesorios como válvulas.', 1);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AA052', 'Campo de Petróleo/Gas', 'Área donde se ha identificado la presencia de petróleo, aceite y/o gas natural.', 2);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AA012', 'Cantera', 'Explotación generalmente a cielo abierto de la que se obtienen rocas industriales, ornamentales y otros materiales usados en la construcción.', 3);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AA010', 'Mina', 'Excavación hecha en la tierra para la extracción de materiales de depósitos naturales.', 4);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AA050', 'Pozo', 'Excavación o perforación hecha en la tierra o mar para la extracción de líquidos o gases.', 5);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AA040', 'Torre de Perforación', 'Superestructura equipada para la perforación o el levantamiento de las operaciones de extracción y / o explotación de recursos naturales.', 6);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BB241', 'Astillero', 'Área  al lado del mar o un río importante, que incluye  instalaciones en las que los buques se construyen o reparan.', 7);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AC040', 'Instalación Petrolera', 'Área con instalaciones para la producción o distribución de petróleo, aceite y/o productos de gas natural.', 8);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AC000', 'Planta de Procesamiento', 'Instalación que incluye uno o más edificios utilizados para procesar materiales.', 9);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH220', 'Planta de Tratamiento de Agua', 'Instalaciones para el almacenamiento, purificación y suministro del agua para un área o una ciudad.', 10);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AE010', 'Planta Ensambladora', 'Edificio o grupo de edificios dedicados a combinar piezas fabricadas para obtener un producto terminado.', 11);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AC030', 'Tanque de Decantación', 'Sitio donde la materia sólida se precipita de un líquido mediante sedimentación.', 12);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH175', 'Abrevadero', 'Contenedor abierto de retención de agua para dar de beber a los animales.', 13);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AJ030', 'Corral', 'Lugar cerrado en el cual el ganado es custodiado temporalmente.', 14);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AJ080', 'Establo', 'Lugar cubierto adaptado para el refugio y alimentación del ganado y las aves.', 15);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AJ060', 'Hacienda', 'Lugar que puede ser de cualquier tamaño desde unas pocas hectáreas a miles de hectáreas, y puede estar especializada en una particular forma de producción de alimento y/o ganado.', 16);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AJ070', 'Rancho', 'Extensión de tierra, incluye las estructuras, cuyo principal uso es el pastoreo de ganado en general, puede presentar también cultivos.', 17);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH240', 'Sistema de Irrigación', 'Sistema para proveer de agua a la tierra, generalmente a través de una red de canales o tuberías.', 18);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AD010', 'Central Eléctrica', 'Edificio y equipamiento necesario para la generación de energía eléctrica.', 19);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AT030', 'Línea de Transmisión Eléctrica', 'Cable que transmite o distribuye energía eléctrica.', 20);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AD030', 'Subestación Eléctrica', 'Infraestructura localizada sobre la ruta de la línea de energía eléctrica en la cual se transforma  y/o se distribuye la energía.', 21);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AT010', 'Antena Parabólica', 'Objeto cóncavo utilizado para la transmisión o recepción de señales electromagnéticas.', 22);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AT060', 'Línea Telefónica', 'Sistema de comunicación que transmite señales eléctricas con información a distancias muy largas.', 23);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AT080', 'Torre de Comunicación', 'Estructura relativamente alta utilizada para transmitir, y/o recibir señales de comunicación electromagnéticas.', 24);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AF010', 'Chimenea', 'Estructura vertical que contiene un tubo o cañón para descarga de humo o gases de combustión.', 25);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AF070', 'Mechero', 'Tubería abierta en la cual los gases residuales son quemados.', 26);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AF030', 'Torre de Enfriamiento', 'Torre utilizada para enfriar líquidos.', 27);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ113', 'Tubería', 'Serie de tubos conectados para el transporte de sólidos, líquidos o gases.', 28);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AM010', 'Bodega', 'Área utilizada para almacenamiento de productos o suministros.', 29);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AM040', 'Pila Mineral', 'Montículo de productos mineros o de cantera, extraídos por el hombre, que no contienen materiales de desecho.', 30);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AM091', 'Silo', 'Contenedor cilíndrico cerrado, utilizado para guardar el grano o forraje.', 31);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AM070', 'Tanque de Almacenamiento', 'Depósito usado para el almacenamiento de líquidos y/o gases.', 32);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AM080', 'Torre de Agua', 'Torre que sirve de apoyo a un tanque elevado de almacenamiento de agua.', 33);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AB021', 'Difusor/Colector', 'Instalación artificial, generalmente subterránea donde los líquidos son evacuados.', 34);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AB030', 'Instalación para Procesamiento de Residuos', 'Sitio funcional con edificios y otras instalaciones, donde los residuos son procesados a través de  procedimientos químicos, físicos, biológicos o térmicos, o combinaciones de estos.', 35);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AB000', 'Vertedero/Basurero', 'Área para la recolección o depósito de materiales de desecho o descarga.', 36);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL135', 'Comunidad', 'Concentración de viviendas nativas, generalmente chozas, usualmente de construcción tradicional.', 37);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL015', 'Edificio', 'Estructura techada relativamente permanente, diseñada para algún uso particular.', 38);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL105', 'Poblado', 'Concentración continua ocupada de tiendas  o ligeras estructuras fijas (por ejemplo: chozas) que sirven como residencia.', 39);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL020', 'Zona Edificada', 'Área que contiene concentración de construcciones y/u otras estructuras.', 40);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL030', 'Cementerio', 'Sitio de estructuras asociadas, utilizadas para el entierro de muertos.', 41);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL070', 'Cerca', 'Barrera artificial construida por el hombre de estructura relativamente liviana utilizada como cercado o límite.', 42);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL099', 'Choza', 'Construcción rústica, pequeña, sencilla e independiente que por lo general tiene una sola habitación individual multifunción.', 43);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ150', 'Escalinata', 'Serie de escalones que sirven para subir a un plano más elevado o para bajar a un plano inferior.', 44);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL130', 'Monumento', 'Estructura levantada o mantenida en memoria a una persona o evento.', 45);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL260', 'Muro', 'Barrera hecha por el hombre de material resistente utilizado como límite o para protección.', 46);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL170', 'Plaza Pública', 'Sitio abierto y que sirve como lugar de reunión pública en una zona poblada para diversos usos.', 47);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH230', 'Pozo de Agua', 'Excavación o perforación hecha en la tierra para la extracción de agua.', 48);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL241', 'Torre', 'Estructura relativamente alta,  que puede presentarse sola o puede formar parte de otra estructura.', 49);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL240', 'Torre que no es para Comunicación', 'Torre  que se utiliza para fines distintos de la comunicación.', 50);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AG030', 'Complejo Comercial', 'Instalaciones comerciales de varios  almacenes, con restaurantes, lugares de entretenimiento y  otras empresas,  está completamente cubierto y cuenta con una amplia zona de estacionamiento.', 51);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BA011', 'Línea de Costa', 'Línea generada por el contacto entre la tierra y un cuerpo de agua afectado por mareas y definida por el nivel de la pleamar media.', 98);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL014', 'Estructura no Construida', 'Construcción económicamente independiente,  diseñada para apoyar las actividades humanas (por ejemplo:  agricultura,  industria o minería), pero no destinados a la ocupación humana y/o habitación.', 52);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL011', 'Instalación', 'Agrupación de instalaciones, situadas en la misma zona, que apoyan funciones particulares.', 53);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK200', 'Balneario', 'Establecimiento que se levanta cerca de fuentes de aguas mineromedicinales (declaradas de utilidad pública) con la finalidad de utilizar sus propiedades terapéuticas y estéticas.', 54);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK040', 'Cancha', 'Lugar al aire libre destinado a eventos deportivos, ejercicio o juegos.', 55);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK160', 'Coliseo', 'Escenario parcial o totalmente rodeado por una estructura diseñada para permitir a los espectadores de pie o sentados visualizar un evento.  A menudo diseñados en forma y tamaño para dar cabida a deportes específicos (por ejemplo: fútbol, ​​baloncesto, etc.), teatro o actuaciones musicales.', 56);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK165', 'Estadio', 'Campo deportivo parcial o totalmente rodeado por una estructura diseñada para permitir a los espectadores ver un evento de pie o sentados; a menudo diseñados en forma y tamaño para dar cabida a deportes específicos (por ejemplo: el fútbol).', 57);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK121', 'Mirador', 'Área, generalmente en un lugar elevado, con infraestructura para observaciones del paisaje circundante.', 58);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK120', 'Parque', 'Área utilizada con propósitos recreacionales u ornamentales.', 59);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK030', 'Parque de Diversión', 'Instalación predominantemente artificial, equipada con dispositivos recreacionales.', 60);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK190', 'Paseo Marítimo', 'Estructura que se extiende en el agua utilizada con propósitos recreacionales, no pretende ser un lugar de atraque de buques.', 61);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK170', 'Piscina', 'Construcción destinada a contener agua con fines de recreación y natación.', 62);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK130', 'Pista de Carreras', 'Superficie que se utiliza para competencias de carreras.', 63);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK166', 'Plaza de Toros', 'Construcción generalmente circular u ovalada, de cielo abierto, rodeada por graderíos para los espectadores.', 64);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK090', 'Recinto Ferial', 'Área donde existen instalaciones permanentes al aire libre para realizar ferias, circos o exhibiciones.', 65);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL200', 'Ruinas', 'Remanentes deteriorados de estructuras no especificadas.', 66);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL012', 'Sitio Arqueológico', 'Sitio donde se ha descubierto la existencia de restos de civilizaciones ancestrales o actividades humanas.', 67);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL201', 'Sitio Histórico', 'Sitio o área declarada de significado histórico nacional o provincial mantenido para el público.', 68);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK110', 'Tribuna', 'Estructura elevada en vías, centros deportivos, etc. generalmente para la presentación especial de eventos al aire libre.', 69);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK180', 'Zoológico', 'Lugar donde los animales, generalmente salvajes, se mantienen en exposición al público, pueden reproducirse y ser estudiados.', 70);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL142', 'Observatorio Astronómico', 'Edificio diseñado y equipado para realizar observaciones de objetos celestes, del espacio y del universo en su conjunto.', 71);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AN010', 'Ferrocarril', 'Una o más vías de ferrocarril que comprende una red utilizada para el transporte de pasajeros y/o bienes.', 72);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AN070', 'Estación de Ferrocarril', 'Instalación en la que los pasajeros pueden subir y bajar de los trenes y/o cargar  y descargar  mercancías del transporte ferroviario.', 73);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ180', 'Estación de Pesaje', 'Construcción y equipos asociados que se utilizan para examinar y pesar  los vehículos de motor.', 74);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ170', 'Gasolinera', 'Establecimiento en el cual se vende combustible y lubricantes generalmente para vehículos de motor.', 75);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AP020', 'Intercambiador Vial', 'Conexión diseñada para facilitar el acceso del tráfico de una carretera a  otra.', 76);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AP010', 'Rodera', 'Vía natural con poca o ninguna mejora por la que pueden transitar vehículos de doble tracción.', 77);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AP050', 'Sendero', 'Camino angosto abierto por el tránsito de personas o animales.', 78);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AP030', 'Vía o Ruta', 'Trayecto con una superficie especialmente  preparada que se mantiene para ser usada por vehículos generalmente a motor.', 79);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AT041', 'Transporte Aéreo por Cable', 'Sistema de transporte que consiste en cables de carga  unidos entre torres en los que están suspendidas las unidades (por ejemplo: tarabita, teleférico).', 80);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ070', 'Gabarra', 'Ruta definida que cruza una gabarra de una orilla a otra.', 81);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ040', 'Puente', 'Estructura que conecta dos lugares y facilita el paso  de una ruta de  transporte (por ejemplo:carretera o ferrocarril)  sobre un obstáculo del terreno (por ejemplo: cuerpo de agua, barranco y/o carretera).', 82);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ065', 'Alcantarilla', 'Estructura hecha por el hombre que permite el cruce de un cauce de agua bajo una vía u otra infraestructura, así como una construcción destinada a evacuar aguas residuales.', 83);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AP040', 'Control Vehicular', 'Barrera en una ruta de transporte (por ejemplo: una carretera, un ferrocarril, un túnel o un puente) que controla el paso (puede ser abierto o cerrado).', 84);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ036', 'Cuneta', 'Borde de hormigón, asfalto o piedras que forman parte de un canal a lo largo del borde de una calle o carretera.', 85);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ080', 'Estación de Gabarra', 'Lugar donde una gabarra toma o descarga su carga.', 86);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AM510', 'Estación de Transbordo', 'Complejo de edificios, instalaciones asociadas, carreteras y zonas adaptadas, utilizadas para el transbordo de pasajeros y carga entre los mismos o diferentes tipos de transporte.', 87);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ125', 'Estación de Transporte', 'Estación que sirve como un punto de parada a lo largo de una ruta de transporte.', 88);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ140', 'Parqueadero', 'Lugar destinado generalmente para estacionar vehículos.', 89);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AP034', 'Parterre', 'Obra o espacio vial entre dos rutas de transporte para separar el flujo del tráfico (por ejemplo, en sentido contrario).', 90);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AP031', 'Paseo Peatonal / Ciclovía', 'Franja de terreno pavimentada o mejorada que tiene por objeto servir como una vía para  peatones, animales y/o vehículos no motorizado.', 91);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ152', 'Puente Peatonal', 'Estructura elevada o suspendida que permite el  paso de peatones.', 92);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ060', 'Torre de Control', 'Estructura que alberga personas y equipos que cumplen con  la función de controlar el tráfico aéreo, náutico o de trenes.', 93);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ130', 'Túnel', 'Paso subterráneo o submarino, abierto para establecer comunicación.', 94);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH190', 'Albufera', 'Laguna natural que se forma en una bahía o entrada de mar cuya boca ha quedado cerrada por cordones de arena o arrecifes de coral.', 95);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BA023', 'Anteplaya', 'La parte de la costa o playa que se encuentra entre la línea de bajamar y el límite superior de la acción del oleaje normal (arena, grava, arcilla y barro).', 96);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BA030', 'Isla', 'Masa de tierra más pequeña que un continente y rodeada por agua.', 97);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BA040', 'Mar', 'Masa de agua salada que cubre la mayor parte de la superficie de la Tierra.', 99);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BA010', 'Orilla', 'Línea donde una superficie está en contacto con un cuerpo de agua.', 100);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BA050', 'Playa', 'Ribera del mar o de un río grande, formada de arenales en un superficie casi plana.', 101);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BA051', 'Dique', 'Barrera o construcción para contener o detener el agua.', 102);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BI030', 'Esclusa', 'Un par o una serie de compuertas utilizadas para levantar y bajar los barcos a medida que pasan desde el nivel del agua a otra.', 103);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BB043', 'Malecón', 'Murallón que corre paralelo a la orilla del mar o de un río, con la finalidad de proteger de las aguas.', 104);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BB190', 'Muelle', 'Obra construida en un puerto de mar o en la orilla de un río navegable para facilitar las tareas de carga, descarga y para atracar los barcos.', 105);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BB005', 'Puerto', 'Conjunto de obras, instalaciones y servicios que proporcionan el espacio necesario para la estancia de los buques mientras realizan operaciones de carga, descarga, almacenaje y tránsito de viajeros.', 106);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BB041', 'Rompeolas', 'Estructura avanzada hacia el mar que protege un puerto o playa de la acción de las olas.', 107);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BE015', 'Curva Batimétrica', 'Línea que conecta puntos de igual profundidad y por debajo del datum hidrográfico.', 108);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BC020', 'Boya', 'Objeto flotante que se sujeta al fondo del mar, de un lago o de un río, que sirve como ayuda a la navegación.', 109);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BC050', 'Faro', 'Estructura distintiva dentro o fuera de la costa con luz en su parte superior, diseñado para servir como una ayuda a la navegación.', 110);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BD120', 'Arrecife', 'Costa peñascosa, formada en el mar por roca o coral, casi a flor de agua, que constituye peligro para la navegación.', 111);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BD180', 'Naufragio', 'Ruinas de un barco hundido o irreversiblemente dañado.', 112);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BD110', 'Plataforma marina', 'Superficie plana levantada sobre el mar, como etapa de trabajo en la conducción de operaciones mar adentro.', 113);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BD130', 'Roca', 'Formación rocosa aislada, piedra o coral de gran tamaño, que constituye un peligro para la navegación.', 114);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH050', 'Granja Acuática', 'Área cerrada de agua utilizada para la reproducción o cría de camarones, peces y similares.', 115);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH030', 'Acequia', 'Excavación poco profunda construida en tierra con propósitos de drenaje o irrigación.', 116);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH010', 'Acueducto o Canal', 'Cauce artificial que transporta agua en forma de flujo continuo desde un lugar en el que ésta es accesible para consumo u otros usos.', 117);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH090', 'Área de Inundación', 'Área periódicamente cubierta por agua, excluyendo el agua por marea.', 118);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH011', 'Bocatoma', 'Lugar donde el agua es captada en un canal, tubería u otro cuerpo de agua.', 119);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH020', 'Canal de Navegación', 'Canal artificial sin flujo o flujo controlado, construido o usado para navegación.', 120);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH200', 'Característica Miscelánea de Drenaje de Superficie', 'Característica de drenaje de superficie la cual es de naturaleza menor y que no está incluida en otros elementos codificado en estas especificaciones.', 121);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH180', 'Cascada', 'Caída vertical de un curso de agua, producida por brusco desnivel del cauce.', 122);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH015', 'Ciénaga', 'Área permanentemente húmeda de la tierra formada por materia orgánica en descomposición y sobre todo de agua dulce estancada.', 123);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BI010', 'Cisterna', 'Contenedor cubierto, construido por el hombre utilizado para recolectar y almacenar el agua.', 124);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BI040', 'Compuerta', 'Puerta utilizada para regular el flujo de agua.', 125);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH130', 'Embalse', 'Depósito artificial en el que se almacenan las aguas de un río o un arroyo, generalmente mediante una presa o un dique que cierra la boca de un valle.', 126);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ116', 'Estación de Bombeo', 'Instalación para mover sólidos, líquidos o gases a través de presión o succión.', 127);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH081', 'Estanque', 'Depósito construido para recolección o almacenamiento de agua para consumo humano o agropecuario.', 128);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH155', 'Evaporador Salino', 'Piscina poco profunda, normalmente construida por el hombre, en donde se recoge sal por la evaporación natural del agua.', 129);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH080', 'Lago o Laguna', 'Cuerpo de agua, dulce o salada, rodeada por tierra.', 130);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH170', 'Manantial', 'Flujo natural de agua que brota en la superficie de la tierra.', 131);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BI020', 'Presa', 'Estructura generalmente de cemento armado, construida a través de un río, arroyo o canal  para contener o controlar el caudal.', 132);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH145', 'Punto Desvanecido', 'Lugar en el cual la corriente de agua desaparece o se desvanece en el terreno.', 133);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH120', 'Rápidos', 'Partes de un río, donde la corriente fluye con gran rapidez, debido a alteraciones en la superficie provocadas por obstrucciones tale como rocas y peñascos.', 134);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH140', 'Río', 'Curso de agua que fluye naturalmente.', 135);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AJ020', 'Sifón', 'Tubería utilizada para el transporte de líquidos de un nivel  a un nivel inferior, usando la diferencia de presión del líquido para forzar subir a la columna hasta un nivel más alto antes de que caiga a la salida.', 136);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH070', 'Vado', 'Sitio poco profundo en un río o corriente de agua utilizado para cruzar a pie, a caballo o en vehículo.', 137);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH100', 'Zanja', 'Excavación larga y estrecha que se hace en la tierra para echar los cimientos, conducir las aguas, defender los sembríos o usos semejantes.', 138);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('CA010', 'Curva de Nivel', 'Línea que conecta puntos que tienen el mismo valor de altura respecto al datum vertical.', 139);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('CA030', 'Punto Acotado/de Cota', 'Lugar designado con un valor de elevación relativa con respecto a un datum vertical.', 140);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DB010', 'Acantilado', 'Superficie empinada vertical o dominante de una roca o de la tierra.', 141);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DB170', 'Duna', 'Uno o varios montículos o lomas de arena por lo general formadas por el viento.', 142);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DB029', 'Entrada de Cueva', 'Entrada a una serie interconectada de cámaras subterráneas.', 143);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DB160', 'Estrato Rocoso', 'Importante afloramiento del lecho rocoso expuesto.', 144);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DB061', 'Grieta', 'Hendidura, fisura, abertura muy fina en la superficie de la tierra, especialmente en la roca.', 145);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BJ099', 'Límite de Nieve', 'Capa permanente de hielo que cubre una extensión de tierra  o  la cima de una montaña.', 146);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DB090', 'Terraplén', 'Montículo largo de tierra u otro material, realizado por el hombre, que se levanta para hacer una defensa, camino u otra obra semejante.', 147);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DA010', 'Característica del Suelo', 'Región de la tierra que es homogénea con respecto a una característica del suelo.', 148);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH160', 'Salitral', 'Yacimiento natural cuyo lecho está cubierto con sal  incrustada.', 149);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH150', 'Salina', 'Mina de sal.', 150);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DB185', 'Cráter', 'Depresión en el terreno en forma cóncava, generalmente redonda y con bordes escarpados.', 151);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL045', 'Objeto Agregado', 'Lugar que no aparece como un objeto específico, pero con cual la información específica es asociada.', 195);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BJ030', 'Glaciar', 'Gran masa o un río de hielo que se forma por acumulación y  compactación de la nieve en  un terreno alto que se mueve  lentamente por una pendiente o valle por encima de la línea de nieve.', 152);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EC040', 'Desmonte', 'Zona de terreno donde se ha desbrozado la vegetación; para facilitar principalmente: el acceso de una carretera, ferrocarril, tubería, línea de transmisión eléctrica; demarcar una frontera; obtener línea de vista, o para impedir el progreso de los incendios forestales (un cortafuegos).', 153);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZD020', 'Zona sin Información', 'Área que carece de fuentes de cobertura adecuada o donde no se requiere información.', 154);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EA010', 'Cultivo', 'Área que ha sido labrada para plantar diferentes cosechas; se incluyen terrenos con barbecho.', 155);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EA030', 'Vivero', 'Lugar donde arbustos, flores, plantas y árboles se cultivan para transplante, semilla o injerto.', 156);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EB020', 'Matorral', 'Zona cubierta principalmente por especies arbustivas no cultivadas, que están densamente enredadas entre sí.', 157);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EB010', 'Pastizal', 'Vegetación herbácea o pasto que tienen poco o ningún tejido leñoso.', 158);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EC005', 'Árbol', 'Planta perenne, de tronco leñoso que crece a una altura considerable y se ramifica a cierta distancia del suelo.', 159);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EC015', 'Bosque', 'Área con alta densidad de árboles, a veces combinada con maleza y pasto.', 160);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EC060', 'Claro de Bosque', 'Sitio en un bosque que ha sido limpiado, a menudo por la agricultura de corte, quema y/o como resultado de la tala maderera. También puede producirse por causas naturales, tales como un incendio forestal.', 161);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EE020', 'Tierra sin Vegetación', 'Una zona con cobertura menor al 5 % o sin vegetación.', 162);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ED030', 'Zona de Manglar', 'Denso matorral de mangle que está sujeto a inundación por mareas y formación de pantanos.', 163);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ED020', 'Pantano', 'Terreno húmedo y lodoso, con un drenaje muy pobre, tiene cierto tipo de vegetación acuática y  dificulta el tránsito.', 164);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FA000', 'Límite Administrativo', 'Límite entre zonas controladas administrativamente.', 165);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FA001', 'Zona Administrativa', 'Área controlada mediante una autoridad administrativa.', 166);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZB030', 'Hito', 'Marca que indica un punto físico sobre la superficie de la tierra cuya posición ha sido medida.', 167);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('IA041', 'Manzana', 'Superficie de terreno o agrupación de lotes cuyo conjunto está delimitado por vías de transito y/o accidentes geográficos naturales.', 168);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZB060', 'Vértice Geodésico', 'Punto físico sobre la superficie de la tierra que tiene una posición conocida y se estableció como parte de una red geodésica.', 169);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('GB005', 'Aeropuerto', 'Zona provista de un conjunto de pistas, instalaciones y servicios destinados al tráfico regular de aeronaves.', 170);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('GB015', 'Estacionamiento de Aeronaves', 'Área definida, en un aeródromo terrestre/helipuerto, destinado a acoger aeronaves y helicópteros  para el embarque y desembarque de pasajeros, correo o carga y para abastecerse de combustible, estacionamiento  o mantenimiento.', 171);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('GB035', 'Helipuerto', 'Aeródromo utilizado para aterrizaje y despegue vertical de helicópteros.', 172);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('GB055', 'Pista de Aterrizaje', 'Área rectangular definida en un campo de aviación o aeropuerto, utilizada para despegue y aterrizaje de aeronaves.', 173);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('GB075', 'Pista de Rodadura', 'Ruta definida en un aeródromo, establecido para  el rodaje de aeronaves  y destinada a proporcionar un enlace de movimiento en tierra  entre una parte del aeródromo y otra.', 174);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('SU001', 'Base Militar', 'Conjunto de instalaciones destinadas para el uso militar, que proporcionan apoyo en combate, a fin de que cuenten con las mejores condiciones operativas para el cumplimiento de las tareas asignadas; brindando un soporte  logístico, técnico y de seguridad necesarios.', 175);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AT045', 'Estación de Radar', 'Instalación que utiliza el radar para detectar y analizar objetos (por ejemplo: aviones, buques, satélites artificiales, asteroides, y/o misiles) y/o fenómenos ambientales (por ejemplo: tornados).', 177);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AM065', 'Instalación de Almacenamiento de Municiones', 'Depósito para el almacenamiento y mantenimiento de municiones y explosivos (por ejemplo: bombas, misiles, ojivas, minas o municiones).', 178);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AH070', 'Puesto de Control', 'Lugar donde se registran, declaran y/o inspeccionan bienes y/o personas.', 179);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL121', 'Zona de Artillería Anti-Aérea', 'Zona de instalaciones relacionadas (por ejemplo: edificios y/o equipos de radar) para el almacenamiento y emplazamiento de artillería anti-aérea.', 180);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FC050', 'Área de Disparo y/o Práctica Naval', 'Área donde la fuerza naval (por ejemplo:buques o aeronaves) ejecutan ejercicios de disparo de munición  y lanzamiento de misiles en forma real.', 181);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FA165', 'Área de Entrenamiento', 'Sitio destinado a la instrucción y adiestramiento especializado del personal movilizado para completar las dotaciones de guerra de las unidades y reparticiones del ejercito, así como para proporcionar los reemplazos necesarios a las tropas en combate.', 182);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FC055', 'Área de Operaciones Navales', 'Área donde la fuerza naval ejecuta operaciones.', 183);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FC200', 'Campo Minado', 'Parte del terreno sembrado de minas Antitanques y Antipersonal está destinado a retardar, desgastar y encauzar al adversario. En guerra naval es área de mar sembrada de minas antibuque y/o antisubmarinas, con el propósito de impedir el tráfico marítimo enemigo y/o proteger lugares de interés en el litoral, tales como puertos, bahías y canales.', 184);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FA021', 'Límite Marítimo', 'Línea donde actividades determinadas o ciertos factores aplican tanto para la navegación u operación.', 185);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FA015', 'Polígono de Tiro', 'Sitio designado con el propósito de disparar municiones y detonar explosivos.', 186);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FA517', 'Unidad Militar', 'Área que es de responsabilidad de un comando jurisdiccional.', 187);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FC046', 'Área de un Cuerpo de Agua', 'Cuerpo de agua geográficamente definido (por ejemplo: el mar u otras aguas navegables).', 188);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZI015', 'Colección de Nombres', 'Conjunto de nombres geográficos recogidos por una entidad de modelo que los utiliza para denotar una características junto con una ubicación geográfica adecuada para su uso en nomenclátor.', 189);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DA031', 'Denominación de la Parcela de Tierra', 'Parcela de un territorio natural, definido por sus características geográficas y conocido por su propio nombre.', 190);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZD040', 'Nombre de Sitio', 'Sitio geográfico sobre la superficie de la tierra que tiene nombre propio.', 191);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZI005', 'Nombre Geográfico', 'Nombre usado para denotar un objeto y la información de relación para establecer el contexto del uso, por parte de una entidad de modelo específica (por ejemplo: base de datos geográfica).', 192);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DB000', 'Superficie de la Tierra', 'Parte de la tierra geográficamente definida.', 193);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZI033', 'Series', 'Para representar las hojas que de acuerdo a la escala se dividen para cubrir el país', 194);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZD012', 'Punto de Información Geográfica', 'Región en la que múltiples características que tiene la misma función  se representa como  objeto contiguo agregado.', 196);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AI030', 'Campamento Militar', 'Instalaciones generalmente en terreno abierto que pueden ser movidas con facilidad, sirven como residencia a tiempo completo o temporal.', 176);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BD122', 'Banco de Arena', 'Acumulación de arena, grava o guijarros en el lecho de un río.', 0);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH165', 'Aliviadero', 'Estructura hidráulica destinada a permitir el pase libre o controlado del agua en los escurrimientos superficiales; siendo el aliviadero en exclusiva para el desagüe.', 0);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ035', 'Acera', 'Ruta pavimentada o mejorada para uso del peatón, normalmente se encuentra adyacente y paralela a una calle o carretera. ', 197);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ037', 'Bordillo', 'Borde de hormigón, asfalto o piedras que forman el borde de una acera a lo largo de la orilla de una calle o carretera. Se debe incluir aquellos que formen parte de los parterres.', 198);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AJ110', 'Invernadero', 'Edificio construido principalmente de material transparente en el que la temperatura y la humedad puede ser controlada para el cultivo y/o protección de plantas.', 199);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZB050', 'Punto de Control', 'Objeto en el terreno de ubicación conocida, donde se ha determinado las coordenadas horizontal y/o vertical por métodos geodésicos o topográficos.', 200);


--
-- TOC entry 7341 (class 0 OID 2455453)
-- Dependencies: 316
-- Data for Name: dit; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.dit VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.dit VALUES (1, '1.- Irrigación');
INSERT INTO catalogo_objetos.dit VALUES (2, '2.- Drenaje');
INSERT INTO catalogo_objetos.dit VALUES (3, '3.- Aguas residuales');
INSERT INTO catalogo_objetos.dit VALUES (998, '998.- No aplica');


--
-- TOC entry 7342 (class 0 OID 2455456)
-- Dependencies: 317
-- Data for Name: ela; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.ela VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.ela VALUES (1, '1.- Preciso');
INSERT INTO catalogo_objetos.ela VALUES (2, '2.- Aproximado');
INSERT INTO catalogo_objetos.ela VALUES (998, '998.- No aplica');


--
-- TOC entry 7343 (class 0 OID 2455459)
-- Dependencies: 318
-- Data for Name: fco; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.fco VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.fco VALUES (1, '1.- Disperso');
INSERT INTO catalogo_objetos.fco VALUES (5, '5.- Divido en igual ancho');
INSERT INTO catalogo_objetos.fco VALUES (6, '6.- Dividido en diferente ancho');
INSERT INTO catalogo_objetos.fco VALUES (7, '7.- Sin divisiones');
INSERT INTO catalogo_objetos.fco VALUES (998, '998.- No aplica');


--
-- TOC entry 7344 (class 0 OID 2455462)
-- Dependencies: 319
-- Data for Name: fti; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.fti VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.fti VALUES (1, '1.- Metal');
INSERT INTO catalogo_objetos.fti VALUES (2, '2.- Madera');
INSERT INTO catalogo_objetos.fti VALUES (3, '3.- Mampostería');
INSERT INTO catalogo_objetos.fti VALUES (4, '4.- Roca');
INSERT INTO catalogo_objetos.fti VALUES (5, '5.- Alambre de púas');
INSERT INTO catalogo_objetos.fti VALUES (6, '6.- Malla');
INSERT INTO catalogo_objetos.fti VALUES (7, '7.- Cable electrificado');
INSERT INTO catalogo_objetos.fti VALUES (8, '8.- Geotextil');
INSERT INTO catalogo_objetos.fti VALUES (9, '9.- Redes');
INSERT INTO catalogo_objetos.fti VALUES (998, '998.- No aplica');


--
-- TOC entry 7345 (class 0 OID 2455465)
-- Dependencies: 320
-- Data for Name: fuc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.fuc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.fuc VALUES (1, '1.- Industrial');
INSERT INTO catalogo_objetos.fuc VALUES (2, '2.- Comercial');
INSERT INTO catalogo_objetos.fuc VALUES (3, '3.- Institucional');
INSERT INTO catalogo_objetos.fuc VALUES (4, '4.- Residencial');
INSERT INTO catalogo_objetos.fuc VALUES (5, '5.- Agricultura');
INSERT INTO catalogo_objetos.fuc VALUES (6, '6.- Marítimo');
INSERT INTO catalogo_objetos.fuc VALUES (8, '8.- Refugio');
INSERT INTO catalogo_objetos.fuc VALUES (9, '9.- Correccional');
INSERT INTO catalogo_objetos.fuc VALUES (10, '10.- Santuario de vida salvaje');
INSERT INTO catalogo_objetos.fuc VALUES (12, '12.- Reserva');
INSERT INTO catalogo_objetos.fuc VALUES (13, '13.- Recreacional');
INSERT INTO catalogo_objetos.fuc VALUES (19, '19.- Urbanización multifuncional');
INSERT INTO catalogo_objetos.fuc VALUES (20, '20.- Transportación');
INSERT INTO catalogo_objetos.fuc VALUES (23, '23.- Medicina');
INSERT INTO catalogo_objetos.fuc VALUES (24, '24.- Preservación forestal');
INSERT INTO catalogo_objetos.fuc VALUES (26, '26.- Educacional');
INSERT INTO catalogo_objetos.fuc VALUES (27, '27.- No comercial');
INSERT INTO catalogo_objetos.fuc VALUES (31, '31.- Cultural');
INSERT INTO catalogo_objetos.fuc VALUES (32, '32.- Gubernamental');
INSERT INTO catalogo_objetos.fuc VALUES (33, '33.- Área prohibida');
INSERT INTO catalogo_objetos.fuc VALUES (34, '34.- Servicio público');
INSERT INTO catalogo_objetos.fuc VALUES (35, '35.- Religioso');
INSERT INTO catalogo_objetos.fuc VALUES (36, '36.- Seguridad');
INSERT INTO catalogo_objetos.fuc VALUES (37, '37.- Militar');
INSERT INTO catalogo_objetos.fuc VALUES (38, '38.- Empresa de Servicio Público');
INSERT INTO catalogo_objetos.fuc VALUES (39, '39.- Recursos para ingeniería o construcción');
INSERT INTO catalogo_objetos.fuc VALUES (40, '40.- Almacenamiento al granel');
INSERT INTO catalogo_objetos.fuc VALUES (41, '41.- Área de oficina');
INSERT INTO catalogo_objetos.fuc VALUES (42, '42.- Investigación');
INSERT INTO catalogo_objetos.fuc VALUES (998, '998.- No aplica');


--
-- TOC entry 7346 (class 0 OID 2455468)
-- Dependencies: 321
-- Data for Name: hct; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.hct VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.hct VALUES (1, '1.- Ruta primaria');
INSERT INTO catalogo_objetos.hct VALUES (2, '2.- Ruta secundaria');
INSERT INTO catalogo_objetos.hct VALUES (3, '3.- Autopista nacional');
INSERT INTO catalogo_objetos.hct VALUES (4, '4.- Ruta local');
INSERT INTO catalogo_objetos.hct VALUES (998, '998.- No aplica');


--
-- TOC entry 7347 (class 0 OID 2455471)
-- Dependencies: 322
-- Data for Name: hyp; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.hyp VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.hyp VALUES (1, '1.- Perenne');
INSERT INTO catalogo_objetos.hyp VALUES (2, '2.- Intermitente');
INSERT INTO catalogo_objetos.hyp VALUES (3, '3.- Eventual');
INSERT INTO catalogo_objetos.hyp VALUES (4, '4.- Seco');
INSERT INTO catalogo_objetos.hyp VALUES (998, '998.- No aplica');


--
-- TOC entry 7348 (class 0 OID 2455474)
-- Dependencies: 323
-- Data for Name: kos; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.kos VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.kos VALUES (1, '1.- Fútbol');
INSERT INTO catalogo_objetos.kos VALUES (2, '2.- Campo de atletismo');
INSERT INTO catalogo_objetos.kos VALUES (3, '3.- Tenis');
INSERT INTO catalogo_objetos.kos VALUES (4, '4.- Equitación');
INSERT INTO catalogo_objetos.kos VALUES (5, '5.- Natación');
INSERT INTO catalogo_objetos.kos VALUES (6, '6.- Pista de esquí');
INSERT INTO catalogo_objetos.kos VALUES (7, '7.- Patinaje de hielo');
INSERT INTO catalogo_objetos.kos VALUES (8, '8.- Deportes de motor');
INSERT INTO catalogo_objetos.kos VALUES (10, '10.- Carreras de perros');
INSERT INTO catalogo_objetos.kos VALUES (11, '11.- Esquí a campo traviesa');
INSERT INTO catalogo_objetos.kos VALUES (12, '12.- Golf');
INSERT INTO catalogo_objetos.kos VALUES (13, '13.- Navegación a vela');
INSERT INTO catalogo_objetos.kos VALUES (14, '14.- Pista de obstáculos');
INSERT INTO catalogo_objetos.kos VALUES (998, '998.- No aplica');


--
-- TOC entry 7349 (class 0 OID 2455477)
-- Dependencies: 324
-- Data for Name: loc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.loc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.loc VALUES (17, '17.- Sobre el fondo de un cuerpo de agua');
INSERT INTO catalogo_objetos.loc VALUES (23, '23.- Bajo el fondo del cuerpo de agua');
INSERT INTO catalogo_objetos.loc VALUES (40, '40.- Bajo la superficie');
INSERT INTO catalogo_objetos.loc VALUES (44, '44.- En la superficie');
INSERT INTO catalogo_objetos.loc VALUES (45, '45.- Sobre la superficie');
INSERT INTO catalogo_objetos.loc VALUES (46, '46.- Sobre el fondo del cuerpo de agua');
INSERT INTO catalogo_objetos.loc VALUES (47, '47.- Bajo la superficie del cuerpo de agua');
INSERT INTO catalogo_objetos.loc VALUES (998, '998.- No aplica');


--
-- TOC entry 7350 (class 0 OID 2455480)
-- Dependencies: 325
-- Data for Name: mes; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.mes VALUES (0, '0.- Falso');
INSERT INTO catalogo_objetos.mes VALUES (1, '1.- Verdadero');


--
-- TOC entry 7351 (class 0 OID 2455483)
-- Dependencies: 326
-- Data for Name: rdt; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.rdt VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.rdt VALUES (2, '2.- Tránsito rápido');
INSERT INTO catalogo_objetos.rdt VALUES (3, '3.- Privada');
INSERT INTO catalogo_objetos.rdt VALUES (4, '4.- Servicio');
INSERT INTO catalogo_objetos.rdt VALUES (5, '5.- Alta velocidad');
INSERT INTO catalogo_objetos.rdt VALUES (6, '6.- Ruta');
INSERT INTO catalogo_objetos.rdt VALUES (7, '7.- Circunvalación');
INSERT INTO catalogo_objetos.rdt VALUES (11, '11.- Camino corto');
INSERT INTO catalogo_objetos.rdt VALUES (45, '45.- Camino de herradura');
INSERT INTO catalogo_objetos.rdt VALUES (46, '46.- Cruce/intersección de caminos');
INSERT INTO catalogo_objetos.rdt VALUES (998, '998.- No aplica');


--
-- TOC entry 7352 (class 0 OID 2455486)
-- Dependencies: 327
-- Data for Name: rel; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.rel VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.rel VALUES (1, '1.- Budismo');
INSERT INTO catalogo_objetos.rel VALUES (2, '2.- Islam');
INSERT INTO catalogo_objetos.rel VALUES (3, '3.- Católica Romana');
INSERT INTO catalogo_objetos.rel VALUES (4, '4.- Cristiana');
INSERT INTO catalogo_objetos.rel VALUES (5, '5.- Judaísmo');
INSERT INTO catalogo_objetos.rel VALUES (6, '6.- Ortodoxa');
INSERT INTO catalogo_objetos.rel VALUES (7, '7.- Protestante');
INSERT INTO catalogo_objetos.rel VALUES (8, '8.- Sintoísmo');
INSERT INTO catalogo_objetos.rel VALUES (9, '9.- Hinduismo');
INSERT INTO catalogo_objetos.rel VALUES (10, '10.- Chiísmo');
INSERT INTO catalogo_objetos.rel VALUES (11, '11.- Suníes');
INSERT INTO catalogo_objetos.rel VALUES (12, '12.- Nestoriana');
INSERT INTO catalogo_objetos.rel VALUES (13, '13.- Caldea');
INSERT INTO catalogo_objetos.rel VALUES (15, '15.- Religión tribal');
INSERT INTO catalogo_objetos.rel VALUES (998, '998.- No aplica');


--
-- TOC entry 7353 (class 0 OID 2455489)
-- Dependencies: 328
-- Data for Name: rgc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.rgc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.rgc VALUES (1, '1.- Amplia');
INSERT INTO catalogo_objetos.rgc VALUES (2, '2.- Angosta/estrecha');
INSERT INTO catalogo_objetos.rgc VALUES (3, '3.- Estándar/normal');
INSERT INTO catalogo_objetos.rgc VALUES (6, '6.- Monocarril');
INSERT INTO catalogo_objetos.rgc VALUES (998, '998.- No aplica');


--
-- TOC entry 7354 (class 0 OID 2455492)
-- Dependencies: 329
-- Data for Name: rra; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.rra VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.rra VALUES (1, '1.- Carril electrificado');
INSERT INTO catalogo_objetos.rra VALUES (3, '3.- Electrificación aérea');
INSERT INTO catalogo_objetos.rra VALUES (4, '4.- No electrificada');
INSERT INTO catalogo_objetos.rra VALUES (998, '998.- No aplica');


--
-- TOC entry 7355 (class 0 OID 2455495)
-- Dependencies: 330
-- Data for Name: rrc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.rrc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.rrc VALUES (2, '2.- Carline');
INSERT INTO catalogo_objetos.rrc VALUES (6, '6.- Ferrocarril subterráneo');
INSERT INTO catalogo_objetos.rrc VALUES (8, '8.- Transporte para madera');
INSERT INTO catalogo_objetos.rrc VALUES (10, '10.- Miniatura');
INSERT INTO catalogo_objetos.rrc VALUES (11, '11.- Tránsito rápido (Metro)');
INSERT INTO catalogo_objetos.rrc VALUES (13, '13.- Ferrocarril ayuda marina');
INSERT INTO catalogo_objetos.rrc VALUES (14, '14.- Tranvía');
INSERT INTO catalogo_objetos.rrc VALUES (15, '15.- Funicular');
INSERT INTO catalogo_objetos.rrc VALUES (24, '24.- Museo');
INSERT INTO catalogo_objetos.rrc VALUES (32, '32.- Sistema de tránsito automatizado');
INSERT INTO catalogo_objetos.rrc VALUES (33, '33.- Larga distancia');
INSERT INTO catalogo_objetos.rrc VALUES (998, '998.-  No aplica');


--
-- TOC entry 7356 (class 0 OID 2455498)
-- Dependencies: 331
-- Data for Name: rst; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.rst VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.rst VALUES (1, '1.- Duro/pavimentado');
INSERT INTO catalogo_objetos.rst VALUES (2, '2.- Suelto/no pavimentado');
INSERT INTO catalogo_objetos.rst VALUES (3, '3.- Suelto/ligero');
INSERT INTO catalogo_objetos.rst VALUES (4, '4.- Troncos entrecruzados');
INSERT INTO catalogo_objetos.rst VALUES (5, '5.- Hierba/césped');
INSERT INTO catalogo_objetos.rst VALUES (6, '6.- Sin mejoras');
INSERT INTO catalogo_objetos.rst VALUES (7, '7.- Permanente');
INSERT INTO catalogo_objetos.rst VALUES (8, '8.- Temporal');
INSERT INTO catalogo_objetos.rst VALUES (9, '9.- Composición dura');
INSERT INTO catalogo_objetos.rst VALUES (10, '10.- PEM');
INSERT INTO catalogo_objetos.rst VALUES (11, '11.- Bituminosas');
INSERT INTO catalogo_objetos.rst VALUES (12, '12.- Composición suave');
INSERT INTO catalogo_objetos.rst VALUES (13, '13.- Tierra clasificada');
INSERT INTO catalogo_objetos.rst VALUES (14, '14.- Tierra sin clasificar');
INSERT INTO catalogo_objetos.rst VALUES (15, '15.- Hielo');
INSERT INTO catalogo_objetos.rst VALUES (16, '16.- Nieve');
INSERT INTO catalogo_objetos.rst VALUES (17, '17.- Macadán');
INSERT INTO catalogo_objetos.rst VALUES (18, '18.- Membrana');
INSERT INTO catalogo_objetos.rst VALUES (19, '19.- Mezcla');
INSERT INTO catalogo_objetos.rst VALUES (20, '20.- Laterita');
INSERT INTO catalogo_objetos.rst VALUES (21, '21.- Arena');
INSERT INTO catalogo_objetos.rst VALUES (22, '22.- Asfalto sobre concreto');
INSERT INTO catalogo_objetos.rst VALUES (23, '23.- Encofrado de acero perforado');
INSERT INTO catalogo_objetos.rst VALUES (24, '24.- Grava');
INSERT INTO catalogo_objetos.rst VALUES (25, '25.- Coral');
INSERT INTO catalogo_objetos.rst VALUES (26, '26.- Arcilla');
INSERT INTO catalogo_objetos.rst VALUES (27, '27.- Concreto');
INSERT INTO catalogo_objetos.rst VALUES (28, '28.- Ladrillo');
INSERT INTO catalogo_objetos.rst VALUES (29, '29.- Asfáltica');
INSERT INTO catalogo_objetos.rst VALUES (30, '30.- Ceniza');
INSERT INTO catalogo_objetos.rst VALUES (31, '31.- Empedrada');
INSERT INTO catalogo_objetos.rst VALUES (32, '32.- Concha');
INSERT INTO catalogo_objetos.rst VALUES (33, '33.- Tablón de madera');
INSERT INTO catalogo_objetos.rst VALUES (998, '998.- No aplica');


--
-- TOC entry 7357 (class 0 OID 2455501)
-- Dependencies: 332
-- Data for Name: slt; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.slt VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.slt VALUES (6, '6.- Manglar');
INSERT INTO catalogo_objetos.slt VALUES (8, '8.- Pantano');
INSERT INTO catalogo_objetos.slt VALUES (11, '11.- Escombros de construcción');
INSERT INTO catalogo_objetos.slt VALUES (12, '12.- Escombros de erosión');
INSERT INTO catalogo_objetos.slt VALUES (13, '13.- Arenoso');
INSERT INTO catalogo_objetos.slt VALUES (14, '14.- Guijarros');
INSERT INTO catalogo_objetos.slt VALUES (15, '15.- Rocoso');
INSERT INTO catalogo_objetos.slt VALUES (16, '16.- Coral');
INSERT INTO catalogo_objetos.slt VALUES (17, '17.- Hielo');
INSERT INTO catalogo_objetos.slt VALUES (18, '18.- Barro');
INSERT INTO catalogo_objetos.slt VALUES (998, '998.- No aplica');


--
-- TOC entry 7358 (class 0 OID 2455504)
-- Dependencies: 333
-- Data for Name: smc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.smc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.smc VALUES (2, '2.- Aluminio');
INSERT INTO catalogo_objetos.smc VALUES (4, '4.- Ceniza');
INSERT INTO catalogo_objetos.smc VALUES (5, '5.- Asfalto');
INSERT INTO catalogo_objetos.smc VALUES (6, '6.- Basalto');
INSERT INTO catalogo_objetos.smc VALUES (7, '7.- Roca Madre');
INSERT INTO catalogo_objetos.smc VALUES (8, '8.- Cantos Rodados');
INSERT INTO catalogo_objetos.smc VALUES (9, '9.- Ladrillo');
INSERT INTO catalogo_objetos.smc VALUES (10, '10.- Calcáreo');
INSERT INTO catalogo_objetos.smc VALUES (12, '12.- Tiza');
INSERT INTO catalogo_objetos.smc VALUES (14, '14.- Cenizas');
INSERT INTO catalogo_objetos.smc VALUES (15, '15.- Cirripedia');
INSERT INTO catalogo_objetos.smc VALUES (16, '16.- Arcilla');
INSERT INTO catalogo_objetos.smc VALUES (17, '17.- Carbón');
INSERT INTO catalogo_objetos.smc VALUES (18, '18.- Empedrado');
INSERT INTO catalogo_objetos.smc VALUES (19, '19.- Coque');
INSERT INTO catalogo_objetos.smc VALUES (20, '20.- Composición');
INSERT INTO catalogo_objetos.smc VALUES (21, '21.- Concreto u Hormigón');
INSERT INTO catalogo_objetos.smc VALUES (22, '22.- Conglomerado');
INSERT INTO catalogo_objetos.smc VALUES (23, '23.- Cobre');
INSERT INTO catalogo_objetos.smc VALUES (24, '24.- Coral');
INSERT INTO catalogo_objetos.smc VALUES (25, '25.- Coral Head');
INSERT INTO catalogo_objetos.smc VALUES (28, '28.- Tierra de diatomeas');
INSERT INTO catalogo_objetos.smc VALUES (29, '29.- Dolomita');
INSERT INTO catalogo_objetos.smc VALUES (34, '34.- Flysch');
INSERT INTO catalogo_objetos.smc VALUES (36, '36.- Foraminíferos');
INSERT INTO catalogo_objetos.smc VALUES (37, '37.- Fucus');
INSERT INTO catalogo_objetos.smc VALUES (40, '40.- Vidrio');
INSERT INTO catalogo_objetos.smc VALUES (42, '42.- Oro');
INSERT INTO catalogo_objetos.smc VALUES (43, '43.- Granito');
INSERT INTO catalogo_objetos.smc VALUES (45, '45.- Materia vegetal');
INSERT INTO catalogo_objetos.smc VALUES (46, '46.- Grava');
INSERT INTO catalogo_objetos.smc VALUES (47, '47.- Rocaverde (Jade)');
INSERT INTO catalogo_objetos.smc VALUES (49, '49.- Suelo  de conchas');
INSERT INTO catalogo_objetos.smc VALUES (51, '51.- Hierro');
INSERT INTO catalogo_objetos.smc VALUES (52, '52.- Lava');
INSERT INTO catalogo_objetos.smc VALUES (54, '54.- Plomo');
INSERT INTO catalogo_objetos.smc VALUES (55, '55.- Loess');
INSERT INTO catalogo_objetos.smc VALUES (56, '56.- Maderos');
INSERT INTO catalogo_objetos.smc VALUES (57, '57.- Macadán');
INSERT INTO catalogo_objetos.smc VALUES (58, '58.- Madrépora');
INSERT INTO catalogo_objetos.smc VALUES (59, '59.- Manganeso');
INSERT INTO catalogo_objetos.smc VALUES (60, '60.- Mármol');
INSERT INTO catalogo_objetos.smc VALUES (61, '61.- Marga');
INSERT INTO catalogo_objetos.smc VALUES (62, '62.- Mampostería');
INSERT INTO catalogo_objetos.smc VALUES (63, '63.- Mate');
INSERT INTO catalogo_objetos.smc VALUES (64, '64.- Metal');
INSERT INTO catalogo_objetos.smc VALUES (65, '65.- Barro');
INSERT INTO catalogo_objetos.smc VALUES (66, '66.- Mejillones');
INSERT INTO catalogo_objetos.smc VALUES (67, '67.- Aceite');
INSERT INTO catalogo_objetos.smc VALUES (69, '69.- Cieno');
INSERT INTO catalogo_objetos.smc VALUES (70, '70.- Ostras');
INSERT INTO catalogo_objetos.smc VALUES (71, '71.- Papel');
INSERT INTO catalogo_objetos.smc VALUES (72, '72.- Parte  Metálica');
INSERT INTO catalogo_objetos.smc VALUES (73, '73.- Guijarros');
INSERT INTO catalogo_objetos.smc VALUES (74, '74.- Plástico');
INSERT INTO catalogo_objetos.smc VALUES (75, '75.- Algas marinas');
INSERT INTO catalogo_objetos.smc VALUES (76, '76.- Pórfido');
INSERT INTO catalogo_objetos.smc VALUES (77, '77.- Hormigón pretensado');
INSERT INTO catalogo_objetos.smc VALUES (79, '79.- Piedra Pómez');
INSERT INTO catalogo_objetos.smc VALUES (80, '80.- Cuarzo');
INSERT INTO catalogo_objetos.smc VALUES (81, '81.- Radiolario');
INSERT INTO catalogo_objetos.smc VALUES (82, '82.- Material radiactivo');
INSERT INTO catalogo_objetos.smc VALUES (83, '83.- Hormigón armado');
INSERT INTO catalogo_objetos.smc VALUES (84, '84.- Piedras');
INSERT INTO catalogo_objetos.smc VALUES (85, '85.- Caucho');
INSERT INTO catalogo_objetos.smc VALUES (86, '86.- Escombros');
INSERT INTO catalogo_objetos.smc VALUES (87, '87.- Sal');
INSERT INTO catalogo_objetos.smc VALUES (88, '88.- Arena');
INSERT INTO catalogo_objetos.smc VALUES (89, '89.- Arenisca');
INSERT INTO catalogo_objetos.smc VALUES (90, '90.- Esquisto');
INSERT INTO catalogo_objetos.smc VALUES (91, '91.- Desperdicio de minas');
INSERT INTO catalogo_objetos.smc VALUES (92, '92.- Escoria');
INSERT INTO catalogo_objetos.smc VALUES (95, '95.- Aguas Residuales');
INSERT INTO catalogo_objetos.smc VALUES (96, '96.- Concha');
INSERT INTO catalogo_objetos.smc VALUES (98, '98.- Guijarro');
INSERT INTO catalogo_objetos.smc VALUES (99, '99.- Limo');
INSERT INTO catalogo_objetos.smc VALUES (100, '100.- Plata');
INSERT INTO catalogo_objetos.smc VALUES (101, '101.- Desechos de metales');
INSERT INTO catalogo_objetos.smc VALUES (102, '102.- Lodos');
INSERT INTO catalogo_objetos.smc VALUES (103, '103.- Agua congelada');
INSERT INTO catalogo_objetos.smc VALUES (104, '104.- Suelo');
INSERT INTO catalogo_objetos.smc VALUES (105, '105.- Espículas');
INSERT INTO catalogo_objetos.smc VALUES (106, '106.- Esponja');
INSERT INTO catalogo_objetos.smc VALUES (107, '107.- Acero');
INSERT INTO catalogo_objetos.smc VALUES (108, '108.- Piedra preciosa');
INSERT INTO catalogo_objetos.smc VALUES (110, '110.- Travertino');
INSERT INTO catalogo_objetos.smc VALUES (111, '111.- Toba');
INSERT INTO catalogo_objetos.smc VALUES (112, '112.- Mineral de  uranio');
INSERT INTO catalogo_objetos.smc VALUES (113, '113.- Vegetación');
INSERT INTO catalogo_objetos.smc VALUES (115, '115.- Ceniza Volcánica');
INSERT INTO catalogo_objetos.smc VALUES (116, '116.- Agua');
INSERT INTO catalogo_objetos.smc VALUES (117, '117.- Madera');
INSERT INTO catalogo_objetos.smc VALUES (118, '118.- Zinc');
INSERT INTO catalogo_objetos.smc VALUES (120, '120.- Arena y Grava');
INSERT INTO catalogo_objetos.smc VALUES (121, '121.- Escollera');
INSERT INTO catalogo_objetos.smc VALUES (122, '122.- Evaporita');
INSERT INTO catalogo_objetos.smc VALUES (124, '124.- Arena y rocas');
INSERT INTO catalogo_objetos.smc VALUES (126, '126.- Arena y barro');
INSERT INTO catalogo_objetos.smc VALUES (128, '128.- Plástico reforzado con vidrio (GRP)');
INSERT INTO catalogo_objetos.smc VALUES (129, '129.- Roca metomórfica');
INSERT INTO catalogo_objetos.smc VALUES (130, '130.- Roca  ígnea');
INSERT INTO catalogo_objetos.smc VALUES (131, '131.- Dolerita');
INSERT INTO catalogo_objetos.smc VALUES (205, '205.- Pintura');
INSERT INTO catalogo_objetos.smc VALUES (257, '257.- Hielo');
INSERT INTO catalogo_objetos.smc VALUES (258, '258.- Nieve');
INSERT INTO catalogo_objetos.smc VALUES (262, '262.- Laterita');
INSERT INTO catalogo_objetos.smc VALUES (266, '266.- Breccia');
INSERT INTO catalogo_objetos.smc VALUES (267, '267.- Cerámica');
INSERT INTO catalogo_objetos.smc VALUES (268, '268.- Gneis');
INSERT INTO catalogo_objetos.smc VALUES (269, '269.- Caliza');
INSERT INTO catalogo_objetos.smc VALUES (270, '270.- Cuarcita');
INSERT INTO catalogo_objetos.smc VALUES (271, '271.- Teja');
INSERT INTO catalogo_objetos.smc VALUES (272, '272.- Lutita – esquisto');
INSERT INTO catalogo_objetos.smc VALUES (273, '273.- Pizarra');
INSERT INTO catalogo_objetos.smc VALUES (274, '274.- Césped');
INSERT INTO catalogo_objetos.smc VALUES (275, '275.- Paja');
INSERT INTO catalogo_objetos.smc VALUES (276, '276.- Madero');
INSERT INTO catalogo_objetos.smc VALUES (277, '277.- Roca sedimentaria');
INSERT INTO catalogo_objetos.smc VALUES (278, '278.- Adobe');
INSERT INTO catalogo_objetos.smc VALUES (279, '279.- Madera tratada');
INSERT INTO catalogo_objetos.smc VALUES (280, '280.- Pasto');
INSERT INTO catalogo_objetos.smc VALUES (998, '998.- No aplica');


--
-- TOC entry 7359 (class 0 OID 2455507)
-- Dependencies: 334
-- Data for Name: tra; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.tra VALUES (0, '0.- Falso');
INSERT INTO catalogo_objetos.tra VALUES (1, '1.- Verdadero');


--
-- TOC entry 7360 (class 0 OID 2455510)
-- Dependencies: 335
-- Data for Name: tuc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.tuc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.tuc VALUES (19, '19.- Ganadería');
INSERT INTO catalogo_objetos.tuc VALUES (25, '25.- Carga');
INSERT INTO catalogo_objetos.tuc VALUES (26, '26.- Pasajeros');
INSERT INTO catalogo_objetos.tuc VALUES (33, '33.- Minerales');
INSERT INTO catalogo_objetos.tuc VALUES (35, '35.- No para transporte');
INSERT INTO catalogo_objetos.tuc VALUES (45, '45.- General');
INSERT INTO catalogo_objetos.tuc VALUES (998, '998.- No aplica');


--
-- TOC entry 7361 (class 0 OID 2455513)
-- Dependencies: 336
-- Data for Name: typ; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.typ VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.typ VALUES (1, '1.- Carretera');
INSERT INTO catalogo_objetos.typ VALUES (5, '5.- Bulevar');
INSERT INTO catalogo_objetos.typ VALUES (9, '9.- Avenida');
INSERT INTO catalogo_objetos.typ VALUES (13, '13.- Paseo');
INSERT INTO catalogo_objetos.typ VALUES (17, '17.- Curva de retorno');
INSERT INTO catalogo_objetos.typ VALUES (21, '21.- Cerrada');
INSERT INTO catalogo_objetos.typ VALUES (25, '25.- Ruta verde (Parkway)');
INSERT INTO catalogo_objetos.typ VALUES (29, '29.- Pasaje');
INSERT INTO catalogo_objetos.typ VALUES (33, '33.- Calle');
INSERT INTO catalogo_objetos.typ VALUES (37, '37.- Terraza');
INSERT INTO catalogo_objetos.typ VALUES (41, '41.- Autopista');
INSERT INTO catalogo_objetos.typ VALUES (45, '45.- Plaza');
INSERT INTO catalogo_objetos.typ VALUES (46, '46.- Rodera');
INSERT INTO catalogo_objetos.typ VALUES (47, '47.- Autopista de acceso restringido');
INSERT INTO catalogo_objetos.typ VALUES (48, '48.- Redondel');
INSERT INTO catalogo_objetos.typ VALUES (49, '49.- Sendero');
INSERT INTO catalogo_objetos.typ VALUES (50, '50.- Rampa');
INSERT INTO catalogo_objetos.typ VALUES (998, '998.- No aplica');


--
-- TOC entry 7362 (class 0 OID 2455516)
-- Dependencies: 337
-- Data for Name: uuc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.uuc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.uuc VALUES (4, '4.- Transformador');
INSERT INTO catalogo_objetos.uuc VALUES (5, '5.- Desagüe');
INSERT INTO catalogo_objetos.uuc VALUES (6, '6.- Represa');
INSERT INTO catalogo_objetos.uuc VALUES (7, '7.- Agua potable');
INSERT INTO catalogo_objetos.uuc VALUES (9, '9.- Dependencia');
INSERT INTO catalogo_objetos.uuc VALUES (10, '10.- Central eléctrica');
INSERT INTO catalogo_objetos.uuc VALUES (11, '11.- Planta de filtración');
INSERT INTO catalogo_objetos.uuc VALUES (12, '12.- Refrigeración');
INSERT INTO catalogo_objetos.uuc VALUES (18, '18.- Central de abastecimiento de agua');
INSERT INTO catalogo_objetos.uuc VALUES (998, '998.- No aplica');


--
-- TOC entry 7363 (class 0 OID 2455519)
-- Dependencies: 338
-- Data for Name: wtc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.wtc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.wtc VALUES (1, '1.- Todo el tiempo (todo el año)');
INSERT INTO catalogo_objetos.wtc VALUES (3, '3.- Solamente en invierno');
INSERT INTO catalogo_objetos.wtc VALUES (4, '4.- Limitada todo el tiempo');
INSERT INTO catalogo_objetos.wtc VALUES (5, '5.- Cerrada en invierno');
INSERT INTO catalogo_objetos.wtc VALUES (998, '998.- No aplica');
INSERT INTO catalogo_objetos.wtc VALUES (2, '2.- Buen clima (época seca)');


--
-- TOC entry 7364 (class 0 OID 2455522)
-- Dependencies: 339
-- Data for Name: wti; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.wti VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.wti VALUES (1, '1.- Independiente');
INSERT INTO catalogo_objetos.wti VALUES (2, '2.- Retener (obstaculizar)');
INSERT INTO catalogo_objetos.wti VALUES (4, '4.- Cercado con árboles');
INSERT INTO catalogo_objetos.wti VALUES (5, '5.- Cerramiento');
INSERT INTO catalogo_objetos.wti VALUES (998, '998.- No aplica');


--
-- TOC entry 7365 (class 0 OID 2455525)
-- Dependencies: 340
-- Data for Name: punto_control_p; Type: TABLE DATA; Schema: d_linderos_propiedad; Owner: postgres
--



--
-- TOC entry 7367 (class 0 OID 2455537)
-- Dependencies: 342
-- Data for Name: cementerio_a; Type: TABLE DATA; Schema: gs_asociado_poblados; Owner: postgres
--



--
-- TOC entry 7369 (class 0 OID 2455549)
-- Dependencies: 344
-- Data for Name: cerca_l; Type: TABLE DATA; Schema: gs_asociado_poblados; Owner: postgres
--



--
-- TOC entry 7371 (class 0 OID 2455561)
-- Dependencies: 346
-- Data for Name: escalinata_a; Type: TABLE DATA; Schema: gs_asociado_poblados; Owner: postgres
--



--
-- TOC entry 7373 (class 0 OID 2455573)
-- Dependencies: 348
-- Data for Name: muro_l; Type: TABLE DATA; Schema: gs_asociado_poblados; Owner: postgres
--



--
-- TOC entry 7375 (class 0 OID 2455585)
-- Dependencies: 350
-- Data for Name: plaza_publica_a; Type: TABLE DATA; Schema: gs_asociado_poblados; Owner: postgres
--



--
-- TOC entry 7377 (class 0 OID 2455597)
-- Dependencies: 352
-- Data for Name: edificio_a; Type: TABLE DATA; Schema: gs_construcciones; Owner: postgres
--



--
-- TOC entry 7379 (class 0 OID 2455609)
-- Dependencies: 354
-- Data for Name: cancha_a; Type: TABLE DATA; Schema: gs_recreacion; Owner: postgres
--



--
-- TOC entry 7381 (class 0 OID 2455621)
-- Dependencies: 356
-- Data for Name: estadio_a; Type: TABLE DATA; Schema: gs_recreacion; Owner: postgres
--



--
-- TOC entry 7383 (class 0 OID 2455633)
-- Dependencies: 358
-- Data for Name: parque_a; Type: TABLE DATA; Schema: gs_recreacion; Owner: postgres
--



--
-- TOC entry 7385 (class 0 OID 2455645)
-- Dependencies: 360
-- Data for Name: piscina_a; Type: TABLE DATA; Schema: gs_recreacion; Owner: postgres
--



--
-- TOC entry 7387 (class 0 OID 2455657)
-- Dependencies: 362
-- Data for Name: plaza_toros_a; Type: TABLE DATA; Schema: gs_recreacion; Owner: postgres
--



--
-- TOC entry 7389 (class 0 OID 2455669)
-- Dependencies: 364
-- Data for Name: acequia_l; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 7391 (class 0 OID 2455681)
-- Dependencies: 366
-- Data for Name: acueducto_canal_a; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 7393 (class 0 OID 2455693)
-- Dependencies: 368
-- Data for Name: lago_laguna_a; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 7395 (class 0 OID 2455705)
-- Dependencies: 370
-- Data for Name: rio_a; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 7397 (class 0 OID 2455717)
-- Dependencies: 372
-- Data for Name: rio_l; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 7399 (class 0 OID 2455729)
-- Dependencies: 374
-- Data for Name: zanja_l; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 7401 (class 0 OID 2455741)
-- Dependencies: 376
-- Data for Name: puerto_a; Type: TABLE DATA; Schema: ho_puertos_muelles; Owner: postgres
--



--
-- TOC entry 7403 (class 0 OID 2455753)
-- Dependencies: 378
-- Data for Name: granja_acuatica_a; Type: TABLE DATA; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--



--
-- TOC entry 7405 (class 0 OID 2455765)
-- Dependencies: 380
-- Data for Name: isla_a; Type: TABLE DATA; Schema: ho_zonas_costeras; Owner: postgres
--



--
-- TOC entry 7407 (class 0 OID 2455777)
-- Dependencies: 382
-- Data for Name: orilla_l; Type: TABLE DATA; Schema: ho_zonas_costeras; Owner: postgres
--



--
-- TOC entry 7409 (class 0 OID 2455789)
-- Dependencies: 384
-- Data for Name: invernadero_a; Type: TABLE DATA; Schema: ii_agropecuaria; Owner: postgres
--



--
-- TOC entry 7411 (class 0 OID 2455802)
-- Dependencies: 386
-- Data for Name: acera_a; Type: TABLE DATA; Schema: it_asociado_transportacion; Owner: postgres
--



--
-- TOC entry 7413 (class 0 OID 2455814)
-- Dependencies: 388
-- Data for Name: bordillo_l; Type: TABLE DATA; Schema: it_asociado_transportacion; Owner: postgres
--



--
-- TOC entry 7415 (class 0 OID 2455826)
-- Dependencies: 390
-- Data for Name: cuneta_a; Type: TABLE DATA; Schema: it_asociado_transportacion; Owner: postgres
--



--
-- TOC entry 7417 (class 0 OID 2455838)
-- Dependencies: 392
-- Data for Name: parqueadero_a; Type: TABLE DATA; Schema: it_asociado_transportacion; Owner: postgres
--



--
-- TOC entry 7419 (class 0 OID 2455850)
-- Dependencies: 394
-- Data for Name: paseo_peatonal_ciclovia_a; Type: TABLE DATA; Schema: it_asociado_transportacion; Owner: postgres
--



--
-- TOC entry 7421 (class 0 OID 2455862)
-- Dependencies: 396
-- Data for Name: tunel_a; Type: TABLE DATA; Schema: it_asociado_transportacion; Owner: postgres
--



--
-- TOC entry 7423 (class 0 OID 2455874)
-- Dependencies: 398
-- Data for Name: puente_a; Type: TABLE DATA; Schema: it_cruces_enlaces; Owner: postgres
--



--
-- TOC entry 7425 (class 0 OID 2455886)
-- Dependencies: 400
-- Data for Name: ferrocarril_a; Type: TABLE DATA; Schema: it_ferrocarriles; Owner: postgres
--



--
-- TOC entry 7427 (class 0 OID 2455898)
-- Dependencies: 402
-- Data for Name: gasolinera_a; Type: TABLE DATA; Schema: it_transporte_terrestre; Owner: postgres
--



--
-- TOC entry 7429 (class 0 OID 2455910)
-- Dependencies: 404
-- Data for Name: intercambiador_vial_a; Type: TABLE DATA; Schema: it_transporte_terrestre; Owner: postgres
--



--
-- TOC entry 7431 (class 0 OID 2455922)
-- Dependencies: 406
-- Data for Name: rodera_l; Type: TABLE DATA; Schema: it_transporte_terrestre; Owner: postgres
--



--
-- TOC entry 7433 (class 0 OID 2455934)
-- Dependencies: 408
-- Data for Name: sendero_l; Type: TABLE DATA; Schema: it_transporte_terrestre; Owner: postgres
--



--
-- TOC entry 7435 (class 0 OID 2455946)
-- Dependencies: 410
-- Data for Name: via_ruta_a; Type: TABLE DATA; Schema: it_transporte_terrestre; Owner: postgres
--



--
-- TOC entry 7437 (class 0 OID 2455958)
-- Dependencies: 412
-- Data for Name: qgis_projects; Type: TABLE DATA; Schema: proyecto_qgis3; Owner: postgres
--

INSERT INTO proyecto_qgis3.qgis_projects VALUES ('CARTOGRAFIA BASE CATASTRAL', '{"last_modified_time": "2022-06-28 12:54:53.24604", "last_modified_user": "postgres"}', '\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');


--
-- TOC entry 6391 (class 0 OID 16696)
-- Dependencies: 237
-- Data for Name: spatial_ref_sys; Type: TABLE DATA; Schema: public; Owner: postgres
--

--
-- TOC entry 7526 (class 0 OID 0)
-- Dependencies: 310
-- Name: aeropuerto_a_gid_seq; Type: SEQUENCE SET; Schema: a_aeropuerto_superficie; Owner: postgres
--

SELECT pg_catalog.setval('a_aeropuerto_superficie.aeropuerto_a_gid_seq', 7, true);


--
-- TOC entry 7527 (class 0 OID 0)
-- Dependencies: 315
-- Name: catalogo_objetos_gid_seq; Type: SEQUENCE SET; Schema: catalogo_objetos; Owner: postgres
--

SELECT pg_catalog.setval('catalogo_objetos.catalogo_objetos_gid_seq', 200, true);


--
-- TOC entry 7528 (class 0 OID 0)
-- Dependencies: 341
-- Name: vertice_geodesico_p_gid_seq; Type: SEQUENCE SET; Schema: d_linderos_propiedad; Owner: postgres
--

SELECT pg_catalog.setval('d_linderos_propiedad.vertice_geodesico_p_gid_seq', 1, true);


--
-- TOC entry 7529 (class 0 OID 0)
-- Dependencies: 343
-- Name: cementerio_a_gid_seq; Type: SEQUENCE SET; Schema: gs_asociado_poblados; Owner: postgres
--

SELECT pg_catalog.setval('gs_asociado_poblados.cementerio_a_gid_seq', 1, false);


--
-- TOC entry 7530 (class 0 OID 0)
-- Dependencies: 345
-- Name: cerca_l_gid_seq; Type: SEQUENCE SET; Schema: gs_asociado_poblados; Owner: postgres
--

SELECT pg_catalog.setval('gs_asociado_poblados.cerca_l_gid_seq', 1, false);


--
-- TOC entry 7531 (class 0 OID 0)
-- Dependencies: 347
-- Name: escalinata_a_gid_seq; Type: SEQUENCE SET; Schema: gs_asociado_poblados; Owner: postgres
--

SELECT pg_catalog.setval('gs_asociado_poblados.escalinata_a_gid_seq', 1, false);


--
-- TOC entry 7532 (class 0 OID 0)
-- Dependencies: 349
-- Name: muro_l_gid_seq; Type: SEQUENCE SET; Schema: gs_asociado_poblados; Owner: postgres
--

SELECT pg_catalog.setval('gs_asociado_poblados.muro_l_gid_seq', 1, false);


--
-- TOC entry 7533 (class 0 OID 0)
-- Dependencies: 351
-- Name: plaza_publica_a_gid_seq; Type: SEQUENCE SET; Schema: gs_asociado_poblados; Owner: postgres
--

SELECT pg_catalog.setval('gs_asociado_poblados.plaza_publica_a_gid_seq', 1, false);


--
-- TOC entry 7534 (class 0 OID 0)
-- Dependencies: 353
-- Name: edificio_a_gid_seq; Type: SEQUENCE SET; Schema: gs_construcciones; Owner: postgres
--

SELECT pg_catalog.setval('gs_construcciones.edificio_a_gid_seq', 1, false);


--
-- TOC entry 7535 (class 0 OID 0)
-- Dependencies: 355
-- Name: cancha_a_gid_seq; Type: SEQUENCE SET; Schema: gs_recreacion; Owner: postgres
--

SELECT pg_catalog.setval('gs_recreacion.cancha_a_gid_seq', 1, false);


--
-- TOC entry 7536 (class 0 OID 0)
-- Dependencies: 357
-- Name: estadio_a_gid_seq; Type: SEQUENCE SET; Schema: gs_recreacion; Owner: postgres
--

SELECT pg_catalog.setval('gs_recreacion.estadio_a_gid_seq', 1, false);


--
-- TOC entry 7537 (class 0 OID 0)
-- Dependencies: 359
-- Name: parque_a_gid_seq; Type: SEQUENCE SET; Schema: gs_recreacion; Owner: postgres
--

SELECT pg_catalog.setval('gs_recreacion.parque_a_gid_seq', 1, false);


--
-- TOC entry 7538 (class 0 OID 0)
-- Dependencies: 361
-- Name: piscina_a_gid_seq; Type: SEQUENCE SET; Schema: gs_recreacion; Owner: postgres
--

SELECT pg_catalog.setval('gs_recreacion.piscina_a_gid_seq', 1, false);


--
-- TOC entry 7539 (class 0 OID 0)
-- Dependencies: 363
-- Name: plaza_toros_a_gid_seq; Type: SEQUENCE SET; Schema: gs_recreacion; Owner: postgres
--

SELECT pg_catalog.setval('gs_recreacion.plaza_toros_a_gid_seq', 1, false);


--
-- TOC entry 7540 (class 0 OID 0)
-- Dependencies: 365
-- Name: acequia_l_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.acequia_l_gid_seq', 1, false);


--
-- TOC entry 7541 (class 0 OID 0)
-- Dependencies: 367
-- Name: acueducto_canal_a_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.acueducto_canal_a_gid_seq', 1, false);


--
-- TOC entry 7542 (class 0 OID 0)
-- Dependencies: 369
-- Name: lago_laguna_a_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.lago_laguna_a_gid_seq', 1, false);


--
-- TOC entry 7543 (class 0 OID 0)
-- Dependencies: 371
-- Name: rio_a_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.rio_a_gid_seq', 1, false);


--
-- TOC entry 7544 (class 0 OID 0)
-- Dependencies: 373
-- Name: rio_l_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.rio_l_gid_seq', 1, false);


--
-- TOC entry 7545 (class 0 OID 0)
-- Dependencies: 375
-- Name: zanja_l_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.zanja_l_gid_seq', 1, false);


--
-- TOC entry 7546 (class 0 OID 0)
-- Dependencies: 377
-- Name: puerto_a_gid_seq; Type: SEQUENCE SET; Schema: ho_puertos_muelles; Owner: postgres
--

SELECT pg_catalog.setval('ho_puertos_muelles.puerto_a_gid_seq', 1, false);


--
-- TOC entry 7547 (class 0 OID 0)
-- Dependencies: 379
-- Name: granja_acuatica_a_gid_seq; Type: SEQUENCE SET; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

SELECT pg_catalog.setval('ho_regulacion_zonas_restringidas.granja_acuatica_a_gid_seq', 1, false);


--
-- TOC entry 7548 (class 0 OID 0)
-- Dependencies: 381
-- Name: isla_a_gid_seq; Type: SEQUENCE SET; Schema: ho_zonas_costeras; Owner: postgres
--

SELECT pg_catalog.setval('ho_zonas_costeras.isla_a_gid_seq', 1, false);


--
-- TOC entry 7549 (class 0 OID 0)
-- Dependencies: 383
-- Name: orilla_l_gid_seq; Type: SEQUENCE SET; Schema: ho_zonas_costeras; Owner: postgres
--

SELECT pg_catalog.setval('ho_zonas_costeras.orilla_l_gid_seq', 1, false);


--
-- TOC entry 7550 (class 0 OID 0)
-- Dependencies: 385
-- Name: invernadero_a_gid_seq; Type: SEQUENCE SET; Schema: ii_agropecuaria; Owner: postgres
--

SELECT pg_catalog.setval('ii_agropecuaria.invernadero_a_gid_seq', 1, false);


--
-- TOC entry 7551 (class 0 OID 0)
-- Dependencies: 387
-- Name: acera_a_gid_seq; Type: SEQUENCE SET; Schema: it_asociado_transportacion; Owner: postgres
--

SELECT pg_catalog.setval('it_asociado_transportacion.acera_a_gid_seq', 1, false);


--
-- TOC entry 7552 (class 0 OID 0)
-- Dependencies: 389
-- Name: bordillo_l_gid_seq; Type: SEQUENCE SET; Schema: it_asociado_transportacion; Owner: postgres
--

SELECT pg_catalog.setval('it_asociado_transportacion.bordillo_l_gid_seq', 1, false);


--
-- TOC entry 7553 (class 0 OID 0)
-- Dependencies: 391
-- Name: cuneta_a_gid_seq; Type: SEQUENCE SET; Schema: it_asociado_transportacion; Owner: postgres
--

SELECT pg_catalog.setval('it_asociado_transportacion.cuneta_a_gid_seq', 1, false);


--
-- TOC entry 7554 (class 0 OID 0)
-- Dependencies: 393
-- Name: parqueadero_a_gid_seq; Type: SEQUENCE SET; Schema: it_asociado_transportacion; Owner: postgres
--

SELECT pg_catalog.setval('it_asociado_transportacion.parqueadero_a_gid_seq', 1, false);


--
-- TOC entry 7555 (class 0 OID 0)
-- Dependencies: 395
-- Name: paseo_peatonal_ciclovia_a_gid_seq; Type: SEQUENCE SET; Schema: it_asociado_transportacion; Owner: postgres
--

SELECT pg_catalog.setval('it_asociado_transportacion.paseo_peatonal_ciclovia_a_gid_seq', 1, false);


--
-- TOC entry 7556 (class 0 OID 0)
-- Dependencies: 397
-- Name: tunel_a_gid_seq; Type: SEQUENCE SET; Schema: it_asociado_transportacion; Owner: postgres
--

SELECT pg_catalog.setval('it_asociado_transportacion.tunel_a_gid_seq', 1, false);


--
-- TOC entry 7557 (class 0 OID 0)
-- Dependencies: 399
-- Name: puente_a_gid_seq; Type: SEQUENCE SET; Schema: it_cruces_enlaces; Owner: postgres
--

SELECT pg_catalog.setval('it_cruces_enlaces.puente_a_gid_seq', 1, false);


--
-- TOC entry 7558 (class 0 OID 0)
-- Dependencies: 401
-- Name: ferrocarril_a_gid_seq; Type: SEQUENCE SET; Schema: it_ferrocarriles; Owner: postgres
--

SELECT pg_catalog.setval('it_ferrocarriles.ferrocarril_a_gid_seq', 1, false);


--
-- TOC entry 7559 (class 0 OID 0)
-- Dependencies: 403
-- Name: gasolinera_a_gid_seq; Type: SEQUENCE SET; Schema: it_transporte_terrestre; Owner: postgres
--

SELECT pg_catalog.setval('it_transporte_terrestre.gasolinera_a_gid_seq', 1, false);


--
-- TOC entry 7560 (class 0 OID 0)
-- Dependencies: 405
-- Name: intercambiador_vial_a_gid_seq; Type: SEQUENCE SET; Schema: it_transporte_terrestre; Owner: postgres
--

SELECT pg_catalog.setval('it_transporte_terrestre.intercambiador_vial_a_gid_seq', 1, false);


--
-- TOC entry 7561 (class 0 OID 0)
-- Dependencies: 407
-- Name: rodera_l_gid_seq; Type: SEQUENCE SET; Schema: it_transporte_terrestre; Owner: postgres
--

SELECT pg_catalog.setval('it_transporte_terrestre.rodera_l_gid_seq', 14157, true);


--
-- TOC entry 7562 (class 0 OID 0)
-- Dependencies: 409
-- Name: sendero_l_gid_seq; Type: SEQUENCE SET; Schema: it_transporte_terrestre; Owner: postgres
--

SELECT pg_catalog.setval('it_transporte_terrestre.sendero_l_gid_seq', 1, false);


--
-- TOC entry 7563 (class 0 OID 0)
-- Dependencies: 411
-- Name: via_ruta_a_gid_seq; Type: SEQUENCE SET; Schema: it_transporte_terrestre; Owner: postgres
--

SELECT pg_catalog.setval('it_transporte_terrestre.via_ruta_a_gid_seq', 105, true);


--
-- TOC entry 6846 (class 2606 OID 2456179)
-- Name: aeropuerto_a aeropuerto_a_pkey; Type: CONSTRAINT; Schema: a_aeropuerto_superficie; Owner: postgres
--

ALTER TABLE ONLY a_aeropuerto_superficie.aeropuerto_a
    ADD CONSTRAINT aeropuerto_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6849 (class 2606 OID 2456181)
-- Name: acc acc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.acc
    ADD CONSTRAINT acc_pkey PRIMARY KEY (acc);


--
-- TOC entry 6851 (class 2606 OID 2456183)
-- Name: atc atc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.atc
    ADD CONSTRAINT atc_pkey PRIMARY KEY (atc);


--
-- TOC entry 6853 (class 2606 OID 2456185)
-- Name: bsc bsc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.bsc
    ADD CONSTRAINT bsc_pkey PRIMARY KEY (bsc);


--
-- TOC entry 6855 (class 2606 OID 2456187)
-- Name: catalogo_objetos catalogo_objetos_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.catalogo_objetos
    ADD CONSTRAINT catalogo_objetos_pkey PRIMARY KEY (fcode);


--
-- TOC entry 6857 (class 2606 OID 2456189)
-- Name: dit dit_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.dit
    ADD CONSTRAINT dit_pkey PRIMARY KEY (dit);


--
-- TOC entry 6859 (class 2606 OID 2456191)
-- Name: ela ela_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.ela
    ADD CONSTRAINT ela_pkey PRIMARY KEY (ela);


--
-- TOC entry 6861 (class 2606 OID 2456193)
-- Name: fco fco_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.fco
    ADD CONSTRAINT fco_pkey PRIMARY KEY (fco);


--
-- TOC entry 6863 (class 2606 OID 2456195)
-- Name: fti fti_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.fti
    ADD CONSTRAINT fti_pkey PRIMARY KEY (fti);


--
-- TOC entry 6865 (class 2606 OID 2456197)
-- Name: fuc fuc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.fuc
    ADD CONSTRAINT fuc_pkey PRIMARY KEY (fuc);


--
-- TOC entry 6867 (class 2606 OID 2456199)
-- Name: hct hct_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.hct
    ADD CONSTRAINT hct_pkey PRIMARY KEY (hct);


--
-- TOC entry 6869 (class 2606 OID 2456201)
-- Name: hyp hyp_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.hyp
    ADD CONSTRAINT hyp_pkey PRIMARY KEY (hyp);


--
-- TOC entry 6871 (class 2606 OID 2456203)
-- Name: kos kos_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.kos
    ADD CONSTRAINT kos_pkey PRIMARY KEY (kos);


--
-- TOC entry 6873 (class 2606 OID 2456205)
-- Name: loc loc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.loc
    ADD CONSTRAINT loc_pkey PRIMARY KEY (loc);


--
-- TOC entry 6875 (class 2606 OID 2456207)
-- Name: mes mes_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.mes
    ADD CONSTRAINT mes_pkey PRIMARY KEY (mes);


--
-- TOC entry 6877 (class 2606 OID 2456209)
-- Name: rdt rdt_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.rdt
    ADD CONSTRAINT rdt_pkey PRIMARY KEY (rdt);


--
-- TOC entry 6879 (class 2606 OID 2456211)
-- Name: rel rel_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.rel
    ADD CONSTRAINT rel_pkey PRIMARY KEY (rel);


--
-- TOC entry 6881 (class 2606 OID 2456213)
-- Name: rgc rgc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.rgc
    ADD CONSTRAINT rgc_pkey PRIMARY KEY (rgc);


--
-- TOC entry 6883 (class 2606 OID 2456215)
-- Name: rra rra_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.rra
    ADD CONSTRAINT rra_pkey PRIMARY KEY (rra);


--
-- TOC entry 6885 (class 2606 OID 2456217)
-- Name: rrc rrc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.rrc
    ADD CONSTRAINT rrc_pkey PRIMARY KEY (rrc);


--
-- TOC entry 6887 (class 2606 OID 2456219)
-- Name: rst rst_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.rst
    ADD CONSTRAINT rst_pkey PRIMARY KEY (rst);


--
-- TOC entry 6889 (class 2606 OID 2456221)
-- Name: slt slt_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.slt
    ADD CONSTRAINT slt_pkey PRIMARY KEY (slt);


--
-- TOC entry 6891 (class 2606 OID 2456223)
-- Name: smc smc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.smc
    ADD CONSTRAINT smc_pkey PRIMARY KEY (smc);


--
-- TOC entry 6893 (class 2606 OID 2456225)
-- Name: tra tra_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.tra
    ADD CONSTRAINT tra_pkey PRIMARY KEY (tra);


--
-- TOC entry 6895 (class 2606 OID 2456227)
-- Name: tuc tuc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.tuc
    ADD CONSTRAINT tuc_pkey PRIMARY KEY (tuc);


--
-- TOC entry 6897 (class 2606 OID 2456229)
-- Name: typ typ_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.typ
    ADD CONSTRAINT typ_pkey PRIMARY KEY (typ);


--
-- TOC entry 6899 (class 2606 OID 2456231)
-- Name: uuc uuc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.uuc
    ADD CONSTRAINT uuc_pkey PRIMARY KEY (uuc);


--
-- TOC entry 6901 (class 2606 OID 2456233)
-- Name: wtc wtc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.wtc
    ADD CONSTRAINT wtc_pkey PRIMARY KEY (wtc);


--
-- TOC entry 6903 (class 2606 OID 2456235)
-- Name: wti wti_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.wti
    ADD CONSTRAINT wti_pkey PRIMARY KEY (wti);


--
-- TOC entry 6905 (class 2606 OID 2456237)
-- Name: punto_control_p punto_control_p_pkey; Type: CONSTRAINT; Schema: d_linderos_propiedad; Owner: postgres
--

ALTER TABLE ONLY d_linderos_propiedad.punto_control_p
    ADD CONSTRAINT punto_control_p_pkey PRIMARY KEY (gid);


--
-- TOC entry 6908 (class 2606 OID 2456239)
-- Name: cementerio_a cementerio_a_pkey; Type: CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cementerio_a
    ADD CONSTRAINT cementerio_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6911 (class 2606 OID 2456241)
-- Name: cerca_l cerca_l_pkey; Type: CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cerca_l
    ADD CONSTRAINT cerca_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 6914 (class 2606 OID 2456243)
-- Name: escalinata_a escalinata_a_pkey; Type: CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.escalinata_a
    ADD CONSTRAINT escalinata_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6917 (class 2606 OID 2456245)
-- Name: muro_l muro_l_pkey; Type: CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.muro_l
    ADD CONSTRAINT muro_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 6920 (class 2606 OID 2456247)
-- Name: plaza_publica_a plaza_publica_a_pkey; Type: CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.plaza_publica_a
    ADD CONSTRAINT plaza_publica_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6923 (class 2606 OID 2456249)
-- Name: edificio_a edificio_a_pkey; Type: CONSTRAINT; Schema: gs_construcciones; Owner: postgres
--

ALTER TABLE ONLY gs_construcciones.edificio_a
    ADD CONSTRAINT edificio_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6926 (class 2606 OID 2456251)
-- Name: cancha_a cancha_a_pkey; Type: CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.cancha_a
    ADD CONSTRAINT cancha_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6929 (class 2606 OID 2456253)
-- Name: estadio_a estadio_a_pkey; Type: CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.estadio_a
    ADD CONSTRAINT estadio_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6932 (class 2606 OID 2456255)
-- Name: parque_a parque_a_pkey; Type: CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.parque_a
    ADD CONSTRAINT parque_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6935 (class 2606 OID 2456257)
-- Name: piscina_a piscina_a_pkey; Type: CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.piscina_a
    ADD CONSTRAINT piscina_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6938 (class 2606 OID 2456259)
-- Name: plaza_toros_a plaza_toros_a_pkey; Type: CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.plaza_toros_a
    ADD CONSTRAINT plaza_toros_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6941 (class 2606 OID 2456261)
-- Name: acequia_l acequia_l_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acequia_l
    ADD CONSTRAINT acequia_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 6944 (class 2606 OID 2456263)
-- Name: acueducto_canal_a acueducto_a_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acueducto_canal_a
    ADD CONSTRAINT acueducto_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6947 (class 2606 OID 2456265)
-- Name: lago_laguna_a lago_laguna_a_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.lago_laguna_a
    ADD CONSTRAINT lago_laguna_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6950 (class 2606 OID 2456267)
-- Name: rio_a rio_a_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_a
    ADD CONSTRAINT rio_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6953 (class 2606 OID 2456269)
-- Name: rio_l rio_l_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_l
    ADD CONSTRAINT rio_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 6957 (class 2606 OID 2456271)
-- Name: zanja_l zanja_l_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.zanja_l
    ADD CONSTRAINT zanja_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 6959 (class 2606 OID 2456273)
-- Name: puerto_a puerto_a_pkey; Type: CONSTRAINT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.puerto_a
    ADD CONSTRAINT puerto_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6962 (class 2606 OID 2456275)
-- Name: granja_acuatica_a granja_acuatica_a_pkey; Type: CONSTRAINT; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

ALTER TABLE ONLY ho_regulacion_zonas_restringidas.granja_acuatica_a
    ADD CONSTRAINT granja_acuatica_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6965 (class 2606 OID 2456277)
-- Name: isla_a isla_a_pkey; Type: CONSTRAINT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.isla_a
    ADD CONSTRAINT isla_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6968 (class 2606 OID 2456279)
-- Name: orilla_l orilla_l_pkey; Type: CONSTRAINT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.orilla_l
    ADD CONSTRAINT orilla_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 6971 (class 2606 OID 2456281)
-- Name: invernadero_a hacienda_a_pkey; Type: CONSTRAINT; Schema: ii_agropecuaria; Owner: postgres
--

ALTER TABLE ONLY ii_agropecuaria.invernadero_a
    ADD CONSTRAINT hacienda_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6974 (class 2606 OID 2456283)
-- Name: acera_a acera_a_pkey; Type: CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.acera_a
    ADD CONSTRAINT acera_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6977 (class 2606 OID 2456285)
-- Name: bordillo_l bordillo_l_pkey; Type: CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.bordillo_l
    ADD CONSTRAINT bordillo_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 6980 (class 2606 OID 2456287)
-- Name: cuneta_a cuneta_a_pkey; Type: CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.cuneta_a
    ADD CONSTRAINT cuneta_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6983 (class 2606 OID 2456289)
-- Name: parqueadero_a parqueadero_a_pkey; Type: CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.parqueadero_a
    ADD CONSTRAINT parqueadero_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6986 (class 2606 OID 2456291)
-- Name: paseo_peatonal_ciclovia_a paseo_peatonal_ciclovia_a_pkey; Type: CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.paseo_peatonal_ciclovia_a
    ADD CONSTRAINT paseo_peatonal_ciclovia_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6989 (class 2606 OID 2456293)
-- Name: tunel_a tunel_a_pkey; Type: CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.tunel_a
    ADD CONSTRAINT tunel_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6992 (class 2606 OID 2456295)
-- Name: puente_a puente_a_pkey; Type: CONSTRAINT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a
    ADD CONSTRAINT puente_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6995 (class 2606 OID 2456297)
-- Name: ferrocarril_a ferrocarril_a_pkey; Type: CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a
    ADD CONSTRAINT ferrocarril_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6998 (class 2606 OID 2456299)
-- Name: gasolinera_a gasolinera_a_pkey; Type: CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.gasolinera_a
    ADD CONSTRAINT gasolinera_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7001 (class 2606 OID 2456301)
-- Name: intercambiador_vial_a intercambiador_vial_a_pkey; Type: CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.intercambiador_vial_a
    ADD CONSTRAINT intercambiador_vial_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7004 (class 2606 OID 2456303)
-- Name: rodera_l rodera_l_pkey; Type: CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 7007 (class 2606 OID 2456305)
-- Name: sendero_l sendero_l_pkey; Type: CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.sendero_l
    ADD CONSTRAINT sendero_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 7011 (class 2606 OID 2456307)
-- Name: via_ruta_a via_ruta_a_pkey; Type: CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7013 (class 2606 OID 2456309)
-- Name: qgis_projects qgis_projects_pkey; Type: CONSTRAINT; Schema: proyecto_qgis3; Owner: postgres
--

ALTER TABLE ONLY proyecto_qgis3.qgis_projects
    ADD CONSTRAINT qgis_projects_pkey PRIMARY KEY (name);


--
-- TOC entry 6847 (class 1259 OID 2456310)
-- Name: sidx_aeropuerto_a; Type: INDEX; Schema: a_aeropuerto_superficie; Owner: postgres
--

CREATE INDEX sidx_aeropuerto_a ON a_aeropuerto_superficie.aeropuerto_a USING gist (the_geom);

ALTER TABLE a_aeropuerto_superficie.aeropuerto_a CLUSTER ON sidx_aeropuerto_a;


--
-- TOC entry 6906 (class 1259 OID 2456311)
-- Name: sidx_punto_control_p; Type: INDEX; Schema: d_linderos_propiedad; Owner: postgres
--

CREATE INDEX sidx_punto_control_p ON d_linderos_propiedad.punto_control_p USING gist (the_geom);


--
-- TOC entry 6909 (class 1259 OID 2456312)
-- Name: sidx_cementerio_a; Type: INDEX; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE INDEX sidx_cementerio_a ON gs_asociado_poblados.cementerio_a USING gist (the_geom);


--
-- TOC entry 6912 (class 1259 OID 2456313)
-- Name: sidx_cerca_l; Type: INDEX; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE INDEX sidx_cerca_l ON gs_asociado_poblados.cerca_l USING gist (the_geom);


--
-- TOC entry 6915 (class 1259 OID 2456314)
-- Name: sidx_escalinata_a; Type: INDEX; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE INDEX sidx_escalinata_a ON gs_asociado_poblados.escalinata_a USING gist (the_geom);


--
-- TOC entry 6918 (class 1259 OID 2456315)
-- Name: sidx_muro_l; Type: INDEX; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE INDEX sidx_muro_l ON gs_asociado_poblados.muro_l USING gist (the_geom);


--
-- TOC entry 6921 (class 1259 OID 2456316)
-- Name: sidx_plaza_publica_a; Type: INDEX; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE INDEX sidx_plaza_publica_a ON gs_asociado_poblados.plaza_publica_a USING gist (the_geom);


--
-- TOC entry 6924 (class 1259 OID 2456317)
-- Name: sidx_edificio_a; Type: INDEX; Schema: gs_construcciones; Owner: postgres
--

CREATE INDEX sidx_edificio_a ON gs_construcciones.edificio_a USING gist (the_geom);

ALTER TABLE gs_construcciones.edificio_a CLUSTER ON sidx_edificio_a;


--
-- TOC entry 6927 (class 1259 OID 2456318)
-- Name: sidx_cancha_a; Type: INDEX; Schema: gs_recreacion; Owner: postgres
--

CREATE INDEX sidx_cancha_a ON gs_recreacion.cancha_a USING gist (the_geom);


--
-- TOC entry 6930 (class 1259 OID 2456319)
-- Name: sidx_estadio_a; Type: INDEX; Schema: gs_recreacion; Owner: postgres
--

CREATE INDEX sidx_estadio_a ON gs_recreacion.estadio_a USING gist (the_geom);


--
-- TOC entry 6933 (class 1259 OID 2456320)
-- Name: sidx_parque_a; Type: INDEX; Schema: gs_recreacion; Owner: postgres
--

CREATE INDEX sidx_parque_a ON gs_recreacion.parque_a USING gist (the_geom);


--
-- TOC entry 6936 (class 1259 OID 2456321)
-- Name: sidx_piscina_a; Type: INDEX; Schema: gs_recreacion; Owner: postgres
--

CREATE INDEX sidx_piscina_a ON gs_recreacion.piscina_a USING gist (the_geom);


--
-- TOC entry 6939 (class 1259 OID 2456322)
-- Name: sidx_plaza_toros_a; Type: INDEX; Schema: gs_recreacion; Owner: postgres
--

CREATE INDEX sidx_plaza_toros_a ON gs_recreacion.plaza_toros_a USING gist (the_geom);


--
-- TOC entry 6942 (class 1259 OID 2456323)
-- Name: sidx_acequia_l; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX sidx_acequia_l ON ho_aguas_interiores.acequia_l USING gist (the_geom);


--
-- TOC entry 6945 (class 1259 OID 2456324)
-- Name: sidx_acueducto_a; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX sidx_acueducto_a ON ho_aguas_interiores.acueducto_canal_a USING gist (the_geom);


--
-- TOC entry 6948 (class 1259 OID 2456325)
-- Name: sidx_lago_laguna_a; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX sidx_lago_laguna_a ON ho_aguas_interiores.lago_laguna_a USING gist (the_geom);


--
-- TOC entry 6951 (class 1259 OID 2456326)
-- Name: sidx_rio_a; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX sidx_rio_a ON ho_aguas_interiores.rio_a USING gist (the_geom);


--
-- TOC entry 6954 (class 1259 OID 2456327)
-- Name: sidx_rio_l; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX sidx_rio_l ON ho_aguas_interiores.rio_l USING gist (the_geom);

ALTER TABLE ho_aguas_interiores.rio_l CLUSTER ON sidx_rio_l;


--
-- TOC entry 6955 (class 1259 OID 2456328)
-- Name: sidx_zanja_l; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX sidx_zanja_l ON ho_aguas_interiores.zanja_l USING gist (the_geom);


--
-- TOC entry 6960 (class 1259 OID 2456329)
-- Name: sidx_puerto_a; Type: INDEX; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE INDEX sidx_puerto_a ON ho_puertos_muelles.puerto_a USING gist (the_geom);


--
-- TOC entry 6963 (class 1259 OID 2456330)
-- Name: sidx_granja_acuatica_a; Type: INDEX; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

CREATE INDEX sidx_granja_acuatica_a ON ho_regulacion_zonas_restringidas.granja_acuatica_a USING gist (the_geom);


--
-- TOC entry 6966 (class 1259 OID 2456331)
-- Name: sidx_isla_a; Type: INDEX; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE INDEX sidx_isla_a ON ho_zonas_costeras.isla_a USING gist (the_geom);


--
-- TOC entry 6969 (class 1259 OID 2456332)
-- Name: sidx_orilla_l; Type: INDEX; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE INDEX sidx_orilla_l ON ho_zonas_costeras.orilla_l USING gist (the_geom);


--
-- TOC entry 6972 (class 1259 OID 2456333)
-- Name: sidx_hacienda_a; Type: INDEX; Schema: ii_agropecuaria; Owner: postgres
--

CREATE INDEX sidx_hacienda_a ON ii_agropecuaria.invernadero_a USING gist (the_geom);


--
-- TOC entry 6975 (class 1259 OID 2456334)
-- Name: acera_a_sidx_paseo_peatonal_ciclovia_a; Type: INDEX; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE INDEX acera_a_sidx_paseo_peatonal_ciclovia_a ON it_asociado_transportacion.acera_a USING gist (the_geom);


--
-- TOC entry 6978 (class 1259 OID 2456335)
-- Name: bordillo_l_sidx_bordillo_l; Type: INDEX; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE INDEX bordillo_l_sidx_bordillo_l ON it_asociado_transportacion.bordillo_l USING gist (the_geom);


--
-- TOC entry 6981 (class 1259 OID 2456336)
-- Name: cuneta_a_sidx_cuneta_a; Type: INDEX; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE INDEX cuneta_a_sidx_cuneta_a ON it_asociado_transportacion.cuneta_a USING gist (the_geom);


--
-- TOC entry 6984 (class 1259 OID 2456337)
-- Name: sidx_parqueadero_a; Type: INDEX; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE INDEX sidx_parqueadero_a ON it_asociado_transportacion.parqueadero_a USING gist (the_geom);


--
-- TOC entry 6987 (class 1259 OID 2456338)
-- Name: sidx_paseo_peatonal_ciclovia_a; Type: INDEX; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE INDEX sidx_paseo_peatonal_ciclovia_a ON it_asociado_transportacion.paseo_peatonal_ciclovia_a USING gist (the_geom);


--
-- TOC entry 6990 (class 1259 OID 2456339)
-- Name: tunel_a_sidx_tunel_a; Type: INDEX; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE INDEX tunel_a_sidx_tunel_a ON it_asociado_transportacion.tunel_a USING gist (the_geom);


--
-- TOC entry 6993 (class 1259 OID 2456340)
-- Name: sidx_puente_a; Type: INDEX; Schema: it_cruces_enlaces; Owner: postgres
--

CREATE INDEX sidx_puente_a ON it_cruces_enlaces.puente_a USING gist (the_geom);


--
-- TOC entry 6996 (class 1259 OID 2456341)
-- Name: ferrocarril_a_sidx_ferrocarril_a; Type: INDEX; Schema: it_ferrocarriles; Owner: postgres
--

CREATE INDEX ferrocarril_a_sidx_ferrocarril_a ON it_ferrocarriles.ferrocarril_a USING gist (the_geom);


--
-- TOC entry 6999 (class 1259 OID 2456342)
-- Name: sidx_gasolinera_a; Type: INDEX; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE INDEX sidx_gasolinera_a ON it_transporte_terrestre.gasolinera_a USING gist (the_geom);


--
-- TOC entry 7002 (class 1259 OID 2456343)
-- Name: sidx_intercambiador_vial_a; Type: INDEX; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE INDEX sidx_intercambiador_vial_a ON it_transporte_terrestre.intercambiador_vial_a USING gist (the_geom);


--
-- TOC entry 7005 (class 1259 OID 2456344)
-- Name: sidx_rodera_l; Type: INDEX; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE INDEX sidx_rodera_l ON it_transporte_terrestre.rodera_l USING gist (the_geom);


--
-- TOC entry 7008 (class 1259 OID 2456345)
-- Name: sidx_sendero_l; Type: INDEX; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE INDEX sidx_sendero_l ON it_transporte_terrestre.sendero_l USING gist (the_geom);


--
-- TOC entry 7009 (class 1259 OID 2456346)
-- Name: sidx_via_ruta_a; Type: INDEX; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE INDEX sidx_via_ruta_a ON it_transporte_terrestre.via_ruta_a USING gist (the_geom);


--
-- TOC entry 7297 (class 2618 OID 2456347)
-- Name: aeropuerto_a omitir_duplicados; Type: RULE; Schema: a_aeropuerto_superficie; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO a_aeropuerto_superficie.aeropuerto_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM a_aeropuerto_superficie.aeropuerto_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7298 (class 2618 OID 2456349)
-- Name: punto_control_p omitir_duplicados; Type: RULE; Schema: d_linderos_propiedad; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO d_linderos_propiedad.punto_control_p
   WHERE (0 <> ( SELECT count(*) AS count
           FROM d_linderos_propiedad.punto_control_p a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7299 (class 2618 OID 2456351)
-- Name: plaza_publica_a omitir_duplicados; Type: RULE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_asociado_poblados.plaza_publica_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_asociado_poblados.plaza_publica_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7300 (class 2618 OID 2456353)
-- Name: muro_l omitir_duplicados; Type: RULE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_asociado_poblados.muro_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_asociado_poblados.muro_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7301 (class 2618 OID 2456355)
-- Name: escalinata_a omitir_duplicados; Type: RULE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_asociado_poblados.escalinata_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_asociado_poblados.escalinata_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7302 (class 2618 OID 2456357)
-- Name: cerca_l omitir_duplicados; Type: RULE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_asociado_poblados.cerca_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_asociado_poblados.cerca_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7303 (class 2618 OID 2456359)
-- Name: cementerio_a omitir_duplicados; Type: RULE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_asociado_poblados.cementerio_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_asociado_poblados.cementerio_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7304 (class 2618 OID 2456361)
-- Name: edificio_a omitir_duplicados; Type: RULE; Schema: gs_construcciones; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_construcciones.edificio_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_construcciones.edificio_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7305 (class 2618 OID 2456363)
-- Name: plaza_toros_a omitir_duplicados; Type: RULE; Schema: gs_recreacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_recreacion.plaza_toros_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_recreacion.plaza_toros_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7306 (class 2618 OID 2456365)
-- Name: piscina_a omitir_duplicados; Type: RULE; Schema: gs_recreacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_recreacion.piscina_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_recreacion.piscina_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7307 (class 2618 OID 2456367)
-- Name: parque_a omitir_duplicados; Type: RULE; Schema: gs_recreacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_recreacion.parque_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_recreacion.parque_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7308 (class 2618 OID 2456369)
-- Name: estadio_a omitir_duplicados; Type: RULE; Schema: gs_recreacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_recreacion.estadio_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_recreacion.estadio_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7309 (class 2618 OID 2456371)
-- Name: cancha_a omitir_duplicados; Type: RULE; Schema: gs_recreacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_recreacion.cancha_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_recreacion.cancha_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7310 (class 2618 OID 2456373)
-- Name: zanja_l omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.zanja_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.zanja_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7311 (class 2618 OID 2456375)
-- Name: rio_l omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.rio_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.rio_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7312 (class 2618 OID 2456377)
-- Name: rio_a omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.rio_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.rio_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7313 (class 2618 OID 2456379)
-- Name: lago_laguna_a omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.lago_laguna_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.lago_laguna_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7314 (class 2618 OID 2456381)
-- Name: acueducto_canal_a omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.acueducto_canal_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.acueducto_canal_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7315 (class 2618 OID 2456383)
-- Name: acequia_l omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.acequia_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.acequia_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7316 (class 2618 OID 2456385)
-- Name: puerto_a omitir_duplicados; Type: RULE; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_puertos_muelles.puerto_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_puertos_muelles.puerto_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7317 (class 2618 OID 2456387)
-- Name: granja_acuatica_a omitir_duplicados; Type: RULE; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_regulacion_zonas_restringidas.granja_acuatica_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_regulacion_zonas_restringidas.granja_acuatica_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7318 (class 2618 OID 2456389)
-- Name: orilla_l omitir_duplicados; Type: RULE; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_zonas_costeras.orilla_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_zonas_costeras.orilla_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7319 (class 2618 OID 2456391)
-- Name: isla_a omitir_duplicados; Type: RULE; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_zonas_costeras.isla_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_zonas_costeras.isla_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7320 (class 2618 OID 2456393)
-- Name: invernadero_a omitir_duplicados; Type: RULE; Schema: ii_agropecuaria; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ii_agropecuaria.invernadero_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ii_agropecuaria.invernadero_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7321 (class 2618 OID 2456395)
-- Name: paseo_peatonal_ciclovia_a omitir_duplicados; Type: RULE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_asociado_transportacion.paseo_peatonal_ciclovia_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_asociado_transportacion.paseo_peatonal_ciclovia_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7322 (class 2618 OID 2456397)
-- Name: parqueadero_a omitir_duplicados; Type: RULE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_asociado_transportacion.parqueadero_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_asociado_transportacion.parqueadero_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7323 (class 2618 OID 2456399)
-- Name: bordillo_l omitir_duplicados; Type: RULE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_asociado_transportacion.bordillo_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_asociado_transportacion.bordillo_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7324 (class 2618 OID 2456401)
-- Name: acera_a omitir_duplicados; Type: RULE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_asociado_transportacion.acera_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_asociado_transportacion.paseo_peatonal_ciclovia_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7325 (class 2618 OID 2456403)
-- Name: tunel_a omitir_duplicados; Type: RULE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_asociado_transportacion.tunel_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_asociado_transportacion.tunel_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7326 (class 2618 OID 2456405)
-- Name: cuneta_a omitir_duplicados; Type: RULE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_asociado_transportacion.cuneta_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_asociado_transportacion.cuneta_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7327 (class 2618 OID 2456407)
-- Name: puente_a omitir_duplicados; Type: RULE; Schema: it_cruces_enlaces; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_cruces_enlaces.puente_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_cruces_enlaces.puente_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7328 (class 2618 OID 2456409)
-- Name: ferrocarril_a omitir_duplicados; Type: RULE; Schema: it_ferrocarriles; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_ferrocarriles.ferrocarril_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_ferrocarriles.ferrocarril_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7329 (class 2618 OID 2456411)
-- Name: via_ruta_a omitir_duplicados; Type: RULE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_transporte_terrestre.via_ruta_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_transporte_terrestre.via_ruta_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7330 (class 2618 OID 2456413)
-- Name: sendero_l omitir_duplicados; Type: RULE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_transporte_terrestre.sendero_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_transporte_terrestre.sendero_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7331 (class 2618 OID 2456415)
-- Name: rodera_l omitir_duplicados; Type: RULE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_transporte_terrestre.rodera_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_transporte_terrestre.rodera_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7332 (class 2618 OID 2456417)
-- Name: intercambiador_vial_a omitir_duplicados; Type: RULE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_transporte_terrestre.intercambiador_vial_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_transporte_terrestre.intercambiador_vial_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7333 (class 2618 OID 2456419)
-- Name: gasolinera_a omitir_duplicados; Type: RULE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_transporte_terrestre.gasolinera_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_transporte_terrestre.gasolinera_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7014 (class 2606 OID 2456421)
-- Name: aeropuerto_a aeropuerto_a_fk; Type: FK CONSTRAINT; Schema: a_aeropuerto_superficie; Owner: postgres
--

ALTER TABLE ONLY a_aeropuerto_superficie.aeropuerto_a
    ADD CONSTRAINT aeropuerto_a_fk FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7015 (class 2606 OID 2456426)
-- Name: aeropuerto_a aeropuerto_a_fk1; Type: FK CONSTRAINT; Schema: a_aeropuerto_superficie; Owner: postgres
--

ALTER TABLE ONLY a_aeropuerto_superficie.aeropuerto_a
    ADD CONSTRAINT aeropuerto_a_fk1 FOREIGN KEY (fuc) REFERENCES catalogo_objetos.fuc(fuc);


--
-- TOC entry 7016 (class 2606 OID 2456431)
-- Name: aeropuerto_a aeropuerto_a_fk2; Type: FK CONSTRAINT; Schema: a_aeropuerto_superficie; Owner: postgres
--

ALTER TABLE ONLY a_aeropuerto_superficie.aeropuerto_a
    ADD CONSTRAINT aeropuerto_a_fk2 FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7017 (class 2606 OID 2456436)
-- Name: punto_control_p punto_control_p_fk; Type: FK CONSTRAINT; Schema: d_linderos_propiedad; Owner: postgres
--

ALTER TABLE ONLY d_linderos_propiedad.punto_control_p
    ADD CONSTRAINT punto_control_p_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7018 (class 2606 OID 2456441)
-- Name: punto_control_p punto_control_p_fk1; Type: FK CONSTRAINT; Schema: d_linderos_propiedad; Owner: postgres
--

ALTER TABLE ONLY d_linderos_propiedad.punto_control_p
    ADD CONSTRAINT punto_control_p_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7019 (class 2606 OID 2456446)
-- Name: punto_control_p punto_control_p_fk2; Type: FK CONSTRAINT; Schema: d_linderos_propiedad; Owner: postgres
--

ALTER TABLE ONLY d_linderos_propiedad.punto_control_p
    ADD CONSTRAINT punto_control_p_fk2 FOREIGN KEY (ela) REFERENCES catalogo_objetos.ela(ela);


--
-- TOC entry 7020 (class 2606 OID 2456451)
-- Name: cementerio_a cementerio_a_fk; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cementerio_a
    ADD CONSTRAINT cementerio_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7021 (class 2606 OID 2456456)
-- Name: cementerio_a cementerio_a_fk1; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cementerio_a
    ADD CONSTRAINT cementerio_a_fk1 FOREIGN KEY (rel) REFERENCES catalogo_objetos.rel(rel);


--
-- TOC entry 7022 (class 2606 OID 2456461)
-- Name: cerca_l cerca_l_fk; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cerca_l
    ADD CONSTRAINT cerca_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7023 (class 2606 OID 2456466)
-- Name: cerca_l cerca_l_fk1; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cerca_l
    ADD CONSTRAINT cerca_l_fk1 FOREIGN KEY (fti) REFERENCES catalogo_objetos.fti(fti);


--
-- TOC entry 7024 (class 2606 OID 2456471)
-- Name: cerca_l cerca_l_fk2; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cerca_l
    ADD CONSTRAINT cerca_l_fk2 FOREIGN KEY (wti) REFERENCES catalogo_objetos.wti(wti);


--
-- TOC entry 7025 (class 2606 OID 2456476)
-- Name: escalinata_a escalinata_a_fk; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.escalinata_a
    ADD CONSTRAINT escalinata_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7026 (class 2606 OID 2456481)
-- Name: escalinata_a escalinata_a_fk1; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.escalinata_a
    ADD CONSTRAINT escalinata_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7027 (class 2606 OID 2456486)
-- Name: muro_l muro_l_fk; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.muro_l
    ADD CONSTRAINT muro_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7028 (class 2606 OID 2456491)
-- Name: muro_l muro_l_fk1; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.muro_l
    ADD CONSTRAINT muro_l_fk1 FOREIGN KEY (wti) REFERENCES catalogo_objetos.wti(wti);


--
-- TOC entry 7029 (class 2606 OID 2456496)
-- Name: plaza_publica_a plaza_publica_a_fk; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.plaza_publica_a
    ADD CONSTRAINT plaza_publica_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7030 (class 2606 OID 2456501)
-- Name: plaza_publica_a plaza_publica_a_fk1; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.plaza_publica_a
    ADD CONSTRAINT plaza_publica_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7031 (class 2606 OID 2456506)
-- Name: edificio_a edificio_a_fk; Type: FK CONSTRAINT; Schema: gs_construcciones; Owner: postgres
--

ALTER TABLE ONLY gs_construcciones.edificio_a
    ADD CONSTRAINT edificio_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7032 (class 2606 OID 2456511)
-- Name: edificio_a edificio_a_fk1; Type: FK CONSTRAINT; Schema: gs_construcciones; Owner: postgres
--

ALTER TABLE ONLY gs_construcciones.edificio_a
    ADD CONSTRAINT edificio_a_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7033 (class 2606 OID 2456516)
-- Name: edificio_a edificio_a_fk2; Type: FK CONSTRAINT; Schema: gs_construcciones; Owner: postgres
--

ALTER TABLE ONLY gs_construcciones.edificio_a
    ADD CONSTRAINT edificio_a_fk2 FOREIGN KEY (uuc) REFERENCES catalogo_objetos.uuc(uuc);


--
-- TOC entry 7034 (class 2606 OID 2456521)
-- Name: cancha_a cancha_a_fk; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.cancha_a
    ADD CONSTRAINT cancha_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7035 (class 2606 OID 2456526)
-- Name: cancha_a cancha_a_fk1; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.cancha_a
    ADD CONSTRAINT cancha_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7036 (class 2606 OID 2456531)
-- Name: cancha_a cancha_a_fk2; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.cancha_a
    ADD CONSTRAINT cancha_a_fk2 FOREIGN KEY (kos) REFERENCES catalogo_objetos.kos(kos);


--
-- TOC entry 7037 (class 2606 OID 2456536)
-- Name: estadio_a estadio_a_fk; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.estadio_a
    ADD CONSTRAINT estadio_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7038 (class 2606 OID 2456541)
-- Name: estadio_a estadio_a_fk1; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.estadio_a
    ADD CONSTRAINT estadio_a_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7039 (class 2606 OID 2456546)
-- Name: parque_a parque_a_fk; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.parque_a
    ADD CONSTRAINT parque_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7040 (class 2606 OID 2456551)
-- Name: parque_a parque_a_fk1; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.parque_a
    ADD CONSTRAINT parque_a_fk1 FOREIGN KEY (fuc) REFERENCES catalogo_objetos.fuc(fuc);


--
-- TOC entry 7041 (class 2606 OID 2456556)
-- Name: piscina_a piscina_a_fk; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.piscina_a
    ADD CONSTRAINT piscina_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7042 (class 2606 OID 2456561)
-- Name: plaza_toros_a plaza_toros_a_fk; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.plaza_toros_a
    ADD CONSTRAINT plaza_toros_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7043 (class 2606 OID 2456566)
-- Name: acequia_l acequia_l_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acequia_l
    ADD CONSTRAINT acequia_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7044 (class 2606 OID 2456571)
-- Name: acequia_l acequia_l_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acequia_l
    ADD CONSTRAINT acequia_l_fk1 FOREIGN KEY (hyp) REFERENCES catalogo_objetos.hyp(hyp);


--
-- TOC entry 7045 (class 2606 OID 2456576)
-- Name: acequia_l acequia_l_fk2; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acequia_l
    ADD CONSTRAINT acequia_l_fk2 FOREIGN KEY (dit) REFERENCES catalogo_objetos.dit(dit);


--
-- TOC entry 7046 (class 2606 OID 2456581)
-- Name: acueducto_canal_a acueducto_canal_a_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acueducto_canal_a
    ADD CONSTRAINT acueducto_canal_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7047 (class 2606 OID 2456586)
-- Name: acueducto_canal_a acueducto_canal_a_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acueducto_canal_a
    ADD CONSTRAINT acueducto_canal_a_fk1 FOREIGN KEY (atc) REFERENCES catalogo_objetos.atc(atc);


--
-- TOC entry 7048 (class 2606 OID 2456591)
-- Name: acueducto_canal_a acueducto_canal_a_fk2; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acueducto_canal_a
    ADD CONSTRAINT acueducto_canal_a_fk2 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7049 (class 2606 OID 2456596)
-- Name: lago_laguna_a lago_laguna_a_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.lago_laguna_a
    ADD CONSTRAINT lago_laguna_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7050 (class 2606 OID 2456601)
-- Name: lago_laguna_a lago_laguna_a_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.lago_laguna_a
    ADD CONSTRAINT lago_laguna_a_fk1 FOREIGN KEY (hyp) REFERENCES catalogo_objetos.hyp(hyp);


--
-- TOC entry 7051 (class 2606 OID 2456606)
-- Name: rio_a rio_a_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_a
    ADD CONSTRAINT rio_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7052 (class 2606 OID 2456611)
-- Name: rio_a rio_a_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_a
    ADD CONSTRAINT rio_a_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7053 (class 2606 OID 2456616)
-- Name: rio_a rio_a_fk2; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_a
    ADD CONSTRAINT rio_a_fk2 FOREIGN KEY (hyp) REFERENCES catalogo_objetos.hyp(hyp);


--
-- TOC entry 7054 (class 2606 OID 2456621)
-- Name: rio_l rio_l_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_l
    ADD CONSTRAINT rio_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7055 (class 2606 OID 2456626)
-- Name: rio_l rio_l_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_l
    ADD CONSTRAINT rio_l_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7056 (class 2606 OID 2456631)
-- Name: rio_l rio_l_fk2; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_l
    ADD CONSTRAINT rio_l_fk2 FOREIGN KEY (hyp) REFERENCES catalogo_objetos.hyp(hyp);


--
-- TOC entry 7057 (class 2606 OID 2456636)
-- Name: zanja_l zanja_l_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.zanja_l
    ADD CONSTRAINT zanja_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7058 (class 2606 OID 2456641)
-- Name: zanja_l zanja_l_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.zanja_l
    ADD CONSTRAINT zanja_l_fk1 FOREIGN KEY (hyp) REFERENCES catalogo_objetos.hyp(hyp);


--
-- TOC entry 7059 (class 2606 OID 2456646)
-- Name: puerto_a puerto_a_fk; Type: FK CONSTRAINT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.puerto_a
    ADD CONSTRAINT puerto_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7060 (class 2606 OID 2456651)
-- Name: granja_acuatica_a granja_acuatica_a_fk; Type: FK CONSTRAINT; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

ALTER TABLE ONLY ho_regulacion_zonas_restringidas.granja_acuatica_a
    ADD CONSTRAINT granja_acuatica_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7061 (class 2606 OID 2456656)
-- Name: isla_a isla_a_fk; Type: FK CONSTRAINT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.isla_a
    ADD CONSTRAINT isla_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7062 (class 2606 OID 2456661)
-- Name: orilla_l orilla_l_fk; Type: FK CONSTRAINT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.orilla_l
    ADD CONSTRAINT orilla_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7063 (class 2606 OID 2456666)
-- Name: orilla_l orilla_l_fk1; Type: FK CONSTRAINT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.orilla_l
    ADD CONSTRAINT orilla_l_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7064 (class 2606 OID 2456671)
-- Name: orilla_l orilla_l_fk2; Type: FK CONSTRAINT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.orilla_l
    ADD CONSTRAINT orilla_l_fk2 FOREIGN KEY (slt) REFERENCES catalogo_objetos.slt(slt);


--
-- TOC entry 7065 (class 2606 OID 2456676)
-- Name: invernadero_a invernadero_a_fk; Type: FK CONSTRAINT; Schema: ii_agropecuaria; Owner: postgres
--

ALTER TABLE ONLY ii_agropecuaria.invernadero_a
    ADD CONSTRAINT invernadero_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7066 (class 2606 OID 2456681)
-- Name: acera_a acera_a_fk; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.acera_a
    ADD CONSTRAINT acera_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7067 (class 2606 OID 2456686)
-- Name: acera_a acera_a_fk1; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.acera_a
    ADD CONSTRAINT acera_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7068 (class 2606 OID 2456691)
-- Name: bordillo_l bordillo_l_fk; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.bordillo_l
    ADD CONSTRAINT bordillo_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7069 (class 2606 OID 2456696)
-- Name: bordillo_l bordillo_l_fk1; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.bordillo_l
    ADD CONSTRAINT bordillo_l_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7070 (class 2606 OID 2456701)
-- Name: cuneta_a cuneta_a_fk; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.cuneta_a
    ADD CONSTRAINT cuneta_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7071 (class 2606 OID 2456706)
-- Name: cuneta_a cuneta_a_fk1; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.cuneta_a
    ADD CONSTRAINT cuneta_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7072 (class 2606 OID 2456711)
-- Name: parqueadero_a parqueadero_a_fk; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.parqueadero_a
    ADD CONSTRAINT parqueadero_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7073 (class 2606 OID 2456716)
-- Name: parqueadero_a parqueadero_a_fk1; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.parqueadero_a
    ADD CONSTRAINT parqueadero_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7074 (class 2606 OID 2456721)
-- Name: paseo_peatonal_ciclovia_a paseo_peatonal_ciclovia_a_fk; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.paseo_peatonal_ciclovia_a
    ADD CONSTRAINT paseo_peatonal_ciclovia_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7075 (class 2606 OID 2456726)
-- Name: paseo_peatonal_ciclovia_a paseo_peatonal_ciclovia_a_fk1; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.paseo_peatonal_ciclovia_a
    ADD CONSTRAINT paseo_peatonal_ciclovia_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7076 (class 2606 OID 2456731)
-- Name: tunel_a tunel_a_fk; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.tunel_a
    ADD CONSTRAINT tunel_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7077 (class 2606 OID 2456736)
-- Name: tunel_a tunel_a_fk1; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.tunel_a
    ADD CONSTRAINT tunel_a_fk1 FOREIGN KEY (tra) REFERENCES catalogo_objetos.tra(tra);


--
-- TOC entry 7078 (class 2606 OID 2456741)
-- Name: tunel_a tunel_a_fk2; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.tunel_a
    ADD CONSTRAINT tunel_a_fk2 FOREIGN KEY (tuc) REFERENCES catalogo_objetos.tuc(tuc);


--
-- TOC entry 7079 (class 2606 OID 2456746)
-- Name: puente_a puente_a_fk; Type: FK CONSTRAINT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a
    ADD CONSTRAINT puente_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7080 (class 2606 OID 2456751)
-- Name: puente_a puente_a_fk1; Type: FK CONSTRAINT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a
    ADD CONSTRAINT puente_a_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7081 (class 2606 OID 2456756)
-- Name: puente_a puente_a_fk2; Type: FK CONSTRAINT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a
    ADD CONSTRAINT puente_a_fk2 FOREIGN KEY (bsc) REFERENCES catalogo_objetos.bsc(bsc);


--
-- TOC entry 7082 (class 2606 OID 2456761)
-- Name: puente_a puente_a_fk3; Type: FK CONSTRAINT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a
    ADD CONSTRAINT puente_a_fk3 FOREIGN KEY (typ) REFERENCES catalogo_objetos.typ(typ);


--
-- TOC entry 7083 (class 2606 OID 2456766)
-- Name: puente_a puente_a_fk4; Type: FK CONSTRAINT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a
    ADD CONSTRAINT puente_a_fk4 FOREIGN KEY (tuc) REFERENCES catalogo_objetos.tuc(tuc);


--
-- TOC entry 7084 (class 2606 OID 2456771)
-- Name: ferrocarril_a ferrocarril_a_fk; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a
    ADD CONSTRAINT ferrocarril_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7085 (class 2606 OID 2456776)
-- Name: ferrocarril_a ferrocarril_a_fk1; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a
    ADD CONSTRAINT ferrocarril_a_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7086 (class 2606 OID 2456781)
-- Name: ferrocarril_a ferrocarril_a_fk2; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a
    ADD CONSTRAINT ferrocarril_a_fk2 FOREIGN KEY (fco) REFERENCES catalogo_objetos.fco(fco);


--
-- TOC entry 7087 (class 2606 OID 2456786)
-- Name: ferrocarril_a ferrocarril_a_fk3; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a
    ADD CONSTRAINT ferrocarril_a_fk3 FOREIGN KEY (loc) REFERENCES catalogo_objetos.loc(loc);


--
-- TOC entry 7088 (class 2606 OID 2456791)
-- Name: ferrocarril_a ferrocarril_a_fk4; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a
    ADD CONSTRAINT ferrocarril_a_fk4 FOREIGN KEY (rgc) REFERENCES catalogo_objetos.rgc(rgc);


--
-- TOC entry 7089 (class 2606 OID 2456796)
-- Name: ferrocarril_a ferrocarril_a_fk5; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a
    ADD CONSTRAINT ferrocarril_a_fk5 FOREIGN KEY (rra) REFERENCES catalogo_objetos.rra(rra);


--
-- TOC entry 7090 (class 2606 OID 2456801)
-- Name: ferrocarril_a ferrocarril_a_fk6; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a
    ADD CONSTRAINT ferrocarril_a_fk6 FOREIGN KEY (rrc) REFERENCES catalogo_objetos.rrc(rrc);


--
-- TOC entry 7091 (class 2606 OID 2456806)
-- Name: gasolinera_a gasolinera_a_fk; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.gasolinera_a
    ADD CONSTRAINT gasolinera_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7092 (class 2606 OID 2456811)
-- Name: intercambiador_vial_a intercambiador_vial_a_fk; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.intercambiador_vial_a
    ADD CONSTRAINT intercambiador_vial_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7093 (class 2606 OID 2456816)
-- Name: intercambiador_vial_a intercambiador_vial_a_fk1; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.intercambiador_vial_a
    ADD CONSTRAINT intercambiador_vial_a_fk1 FOREIGN KEY (hct) REFERENCES catalogo_objetos.hct(hct);


--
-- TOC entry 7094 (class 2606 OID 2456821)
-- Name: intercambiador_vial_a intercambiador_vial_a_fk2; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.intercambiador_vial_a
    ADD CONSTRAINT intercambiador_vial_a_fk2 FOREIGN KEY (rst) REFERENCES catalogo_objetos.rst(rst);


--
-- TOC entry 7095 (class 2606 OID 2456826)
-- Name: intercambiador_vial_a intercambiador_vial_a_fk3; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.intercambiador_vial_a
    ADD CONSTRAINT intercambiador_vial_a_fk3 FOREIGN KEY (loc) REFERENCES catalogo_objetos.loc(loc);


--
-- TOC entry 7096 (class 2606 OID 2456831)
-- Name: rodera_l rodera_l_fk; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7097 (class 2606 OID 2456836)
-- Name: rodera_l rodera_l_fk1; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk1 FOREIGN KEY (typ) REFERENCES catalogo_objetos.typ(typ);


--
-- TOC entry 7098 (class 2606 OID 2456841)
-- Name: rodera_l rodera_l_fk2; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk2 FOREIGN KEY (rst) REFERENCES catalogo_objetos.rst(rst);


--
-- TOC entry 7099 (class 2606 OID 2456846)
-- Name: rodera_l rodera_l_fk3; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk3 FOREIGN KEY (hct) REFERENCES catalogo_objetos.hct(hct);


--
-- TOC entry 7100 (class 2606 OID 2456851)
-- Name: rodera_l rodera_l_fk4; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk4 FOREIGN KEY (rdt) REFERENCES catalogo_objetos.rdt(rdt);


--
-- TOC entry 7101 (class 2606 OID 2456856)
-- Name: rodera_l rodera_l_fk5; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk5 FOREIGN KEY (wtc) REFERENCES catalogo_objetos.wtc(wtc);


--
-- TOC entry 7102 (class 2606 OID 2456861)
-- Name: rodera_l rodera_l_fk6; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk6 FOREIGN KEY (tuc) REFERENCES catalogo_objetos.tuc(tuc);


--
-- TOC entry 7103 (class 2606 OID 2456866)
-- Name: sendero_l sendero_l_fk; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.sendero_l
    ADD CONSTRAINT sendero_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7104 (class 2606 OID 2456871)
-- Name: sendero_l sendero_l_fk1; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.sendero_l
    ADD CONSTRAINT sendero_l_fk1 FOREIGN KEY (wtc) REFERENCES catalogo_objetos.wtc(wtc);


--
-- TOC entry 7105 (class 2606 OID 2456876)
-- Name: via_ruta_a via_ruta_a_fk; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7106 (class 2606 OID 2456881)
-- Name: via_ruta_a via_ruta_a_fk1; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7107 (class 2606 OID 2456886)
-- Name: via_ruta_a via_ruta_a_fk2; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk2 FOREIGN KEY (rst) REFERENCES catalogo_objetos.rst(rst);


--
-- TOC entry 7108 (class 2606 OID 2456891)
-- Name: via_ruta_a via_ruta_a_fk3; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk3 FOREIGN KEY (typ) REFERENCES catalogo_objetos.typ(typ);


--
-- TOC entry 7109 (class 2606 OID 2456896)
-- Name: via_ruta_a via_ruta_a_fk4; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk4 FOREIGN KEY (hct) REFERENCES catalogo_objetos.hct(hct);


--
-- TOC entry 7110 (class 2606 OID 2456901)
-- Name: via_ruta_a via_ruta_a_fk5; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk5 FOREIGN KEY (loc) REFERENCES catalogo_objetos.loc(loc);


--
-- TOC entry 7111 (class 2606 OID 2456906)
-- Name: via_ruta_a via_ruta_a_fk6; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk6 FOREIGN KEY (mes) REFERENCES catalogo_objetos.mes(mes);


--
-- TOC entry 7112 (class 2606 OID 2456911)
-- Name: via_ruta_a via_ruta_a_fk7; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk7 FOREIGN KEY (rdt) REFERENCES catalogo_objetos.rdt(rdt);


--
-- TOC entry 7113 (class 2606 OID 2456916)
-- Name: via_ruta_a via_ruta_a_fk8; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk8 FOREIGN KEY (tuc) REFERENCES catalogo_objetos.tuc(tuc);


-- Completed on 2022-08-25 15:05:38

--
-- PostgreSQL database dump complete
--

